<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ProductoController;
use App\Http\Controllers\VentaController;
use App\Http\Controllers\OrdenController;
use App\Http\Controllers\CarritoController;

// Ruta principal
Route::get('/', function () {
    return redirect('/login');
});

// Rutas de autenticación
Route::controller(AuthController::class)->group(function () {
    Route::get('/register', 'showRegister')->name('register');
    Route::post('/register', 'register');
    Route::get('/login', 'showLogin')->name('login');
    Route::post('/login', 'login');
    Route::post('/logout', 'logout')->name('logout');
});

// Redirección por defecto después del login
Route::get('/home', function () {
    return redirect()->route('productos.index');
})->middleware('auth');

// Rutas protegidas por autenticación
Route::middleware(['auth'])->group(function () {
    // Productos
    Route::get('/productos/create', [ProductoController::class, 'create'])->name('productos.create');
    Route::resource('productos', ProductoController::class)->except(['create', 'edit']);
    Route::get('/productos/{producto}/edit', [ProductoController::class, 'edit'])->name('productos.edit');
    Route::post('/productos/{producto}/venta', [ProductoController::class, 'venta'])->name('productos.venta');

    // Ventas
    Route::controller(VentaController::class)->group(function () {
        Route::get('/ventas', 'index')->name('ventas.index');
        Route::get('/ventas/exportar-pdf', 'exportarPdf')->name('ventas.exportarPdf');
        Route::get('/ventas/exportar-excel', 'exportarExcel')->name('ventas.exportarExcel'); // <-- Nueva ruta para exportar a Excel
        Route::get('/ventas/{venta}', 'show')->name('ventas.show');
        Route::post('/ventas/confirmar', 'confirmar')->name('ventas.confirmar');
        Route::post('/ventas/procesar', 'procesar')->name('ventas.procesar');
    });

    // Órdenes
    Route::controller(OrdenController::class)->group(function () {
        Route::get('/ordenes', 'index')->name('ordenes.index');
        Route::delete('/ordenes/{orden}', 'destroy')->name('ordenes.destroy');
        Route::post('/ordenes/actualizar', 'actualizar')->name('ordenes.actualizar');
    });

    // Carrito
    Route::controller(CarritoController::class)->group(function () {
        Route::get('/carrito', 'index')->name('carrito.index');
        Route::post('/carrito', 'store')->name('carrito.store');
        Route::match(['PUT', 'PATCH'], '/carrito/{id}', 'update')->name('carrito.update');
        Route::delete('/carrito/{id}', 'destroy')->name('carrito.destroy');
        Route::post('/carrito/confirmar', [CarritoController::class, 'confirmarVenta'])->name('ventas.confirmar');
    });
});