@extends('layouts.app')

@section('title', 'Detalle de Venta')

@section('content')
    <h1>Detalle de Venta #{{ $venta->id }}</h1>

    @php
        $totalSinDescuento = $venta->detalles->sum(fn($detalle) => $detalle->cantidad * $detalle->precio);
        $totalFinal = $venta->total;
        $primerDetalle = $venta->detalles->first();
        $metodoPago = $primerDetalle->metodo_pago ?? '-';
        $pagaCon = $primerDetalle->paga_con ?? null;
        $vuelto = $primerDetalle->vuelto ?? null;
    @endphp

    <div class="mb-3">
        <strong>Vendedor:</strong> {{ $venta->user->name ?? '-' }}<br>
        <strong>Fecha:</strong> {{ $venta->created_at->format('d/m/Y H:i') }}<br>
        <strong>Método de Pago:</strong> {{ $metodoPago }}<br>
        @if($metodoPago === 'Cash' && $pagaCon)
            <strong>Paga con:</strong> ${{ number_format($pagaCon, 2) }}<br>
            <strong>Vuelto:</strong> ${{ number_format($vuelto, 2) }}<br>
        @endif
        <strong>Total sin descuento:</strong> ${{ number_format($totalSinDescuento, 2) }}<br>
        <strong>Total con descuento general:</strong> ${{ number_format($totalFinal, 2) }}
    </div>

    <h4>Productos vendidos:</h4>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Producto</th>
                <th>Código</th>
                <th class="text-end">Cantidad</th>
                <th class="text-end">Precio Unitario</th>
                <th class="text-end">Descuento</th>
                <!--<th class="text-end">Descuento Individual</th>-->
            </tr>
        </thead>
        <tbody>
            @foreach($venta->detalles as $detalle)
                @php
                    $subtotal = $detalle->cantidad * $detalle->precio;
                    $descuento = $detalle->descuento_individual ?? 0;
                    $tipo = $detalle->tipo_descuento_individual ?? 'fijo';
                @endphp
                <tr>
                    <td>{{ $detalle->producto->nombre ?? '-' }}</td>
                    <td>{{ $detalle->producto->codigo ?? '-' }}</td>
                    <td class="text-end">{{ $detalle->cantidad }}</td>
                    <td class="text-end">${{ number_format($detalle->precio, 2) }}</td>
                    <td class="text-end">${{ number_format($detalle->descuento, 2) }}</td>
                    <!--<td class="text-end">
                        @if($tipo === 'porcentaje')
                            {{ number_format($descuento, 2) }} %
                        @else
                            ${{ number_format($descuento, 2) }}
                        @endif
                    </td>-->
                </tr>
            @endforeach
        </tbody>
    </table>

    @php
        $infoDescuentos = json_decode($venta->descuentos, true);
        $descuentoGeneral = $infoDescuentos['general']['monto'] ?? 0;
        $tipoDescuentoGeneral = $infoDescuentos['general']['tipo'] ?? 'fijo';
    @endphp

    @if($descuentoGeneral > 0)
        <div class="alert alert-info">
            <strong>Descuento General Aplicado:</strong>
            @if($tipoDescuentoGeneral === 'porcentaje' && $totalSinDescuento > 0)
                {{ number_format(($descuentoGeneral / $totalSinDescuento) * 100, 2) }} %
            @else
                ${{ number_format($descuentoGeneral, 2) }}
            @endif
        </div>
    @endif

    <a href="{{ route('productos.index') }}" class="btn btn-secondary">Volver</a>
@endsection
