@extends('layouts.app')

@section('title', 'Historial de Ventas')

@section('content')
    <h1>Historial de Ventas</h1>

    {{-- Buscador combinado: texto y fechas --}}
    <form method="GET" action="{{ route('ventas.index') }}" class="row g-3 align-items-end mb-4">
        <div class="col-auto">
            <label for="busqueda" class="form-label mb-0">Buscar</label>
            <input type="text" name="busqueda" id="busqueda" class="form-control"
                   value="{{ request('busqueda') }}" placeholder="ID Venta, Vendedor...">
        </div>
        <div class="col-auto">
            <label for="fecha_inicio" class="form-label mb-0">Fecha inicio</label>
            <input type="date" name="fecha_inicio" id="fecha_inicio" class="form-control"
                   value="{{ request('fecha_inicio', '') }}">
        </div>
        <div class="col-auto">
            <label for="fecha_fin" class="form-label mb-0">Fecha fin</label>
            <input type="date" name="fecha_fin" id="fecha_fin" class="form-control"
                   value="{{ request('fecha_fin', '') }}">
        </div>
        <div class="col-auto">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-search"></i>
                Buscar
            </button>
            <a href="{{ route('ventas.index') }}" class="btn btn-outline-secondary">
                <i class="bi bi-x-circle"></i>
                Limpiar
            </a>
        </div>
    </form>

    {{-- Botón exportar a PDF --}}
    <a href="{{ route('ventas.exportarPdf', request()->all()) }}" class="btn btn-success mb-3" target="_blank">
        <i class="bi bi-file-earmark-pdf"></i> Exportar a PDF
    </a>
    {{-- Botón exportar a Excel --}}
    <a href="{{ route('ventas.exportarExcel', request()->all()) }}" class="btn btn-success mb-3" target="_blank">
        <i class="bi bi-file-earmark-excel"></i> Exportar a Excel
    </a>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID Venta</th>
                <th>Vendedor</th>
                <th>Fecha</th>
                <th>Total</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @forelse($ventas as $venta)
                <tr>
                    <td>{{ $venta->id }}</td>
                    <td>{{ $venta->user->name ?? '-' }}</td>
                    <td>{{ $venta->created_at->format('d/m/Y H:i') }}</td>
                    <td>${{ number_format($venta->total, 2) }}</td>
                    <td>
                        <a href="{{ route('ventas.show', $venta->id) }}" class="btn btn-sm btn-info">
                            <i class="bi bi-eye"></i> Detalles
                        </a>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="5">No hay ventas registradas.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
    <div class="mb-2">
        Mostrando {{ $ventas->firstItem() }} a {{ $ventas->lastItem() }} de {{ $ventas->total() }} resultados
    </div>
    <div class="d-flex justify-content-center mt-4">
        {{ $ventas->appends(request()->query())->links('vendor.pagination.bootstrap-5') }}
    </div>
@endsection