<table>
    <thead>
        <tr>
            <th>ID Venta</th>
            <th>Vendedor</th>
            <th>Fecha</th>
            <th>Producto</th>
            <th>Cantidad</th>
            <th>Precio Unitario</th>
            <th>Subtotal</th>
            <th>Descuento</th>
            <th>Total Línea</th>
            <th>Descuento General</th>
        </tr>
    </thead>
    <tbody>
        @foreach($ventas as $venta)
            @php
                $desc = $venta->descuentos ? json_decode($venta->descuentos, true) : [];
                $descuentoGeneral = isset($desc['general']) ? $desc['general']['monto'] . ' (' . $desc['general']['tipo'] . ')' : '0';
            @endphp
            @foreach($venta->detalles as $detalle)
                <tr>
                    <td>{{ $venta->id }}</td>
                    <td>{{ $venta->user->name ?? '-' }}</td>
                    <td>{{ $venta->created_at->format('d/m/Y H:i') }}</td>
                    <td>{{ $detalle->producto->nombre ?? 'Producto eliminado' }}</td>
                    <td>{{ $detalle->cantidad }}</td>
                    <td>{{ $detalle->precio }}</td>
                    <td>{{ $detalle->subtotal }}</td>
                    <td>{{ $detalle->descuento ?? 0 }}</td>
                    <td>{{ $detalle->subtotal - ($detalle->descuento ?? 0) }}</td>
                    <td>{{ $descuentoGeneral }}</td>
                </tr>
            @endforeach
        @endforeach
    </tbody>
</table>