@extends('layouts.app')

@section('content')
<div class="container">
    <h1>Órdenes generadas por stock mínimo</h1>
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form action="{{ route('ordenes.actualizar') }}" method="POST">
        @csrf
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Producto</th>
                    <th>Código</th>
                    <th>Cantidad actual</th>
                    <th>Stock mínimo</th>
                    <th>Stock máximo</th>
                    <th>Precio</th>
                    <th>Descripción</th>
                    <th>Imagen</th>
                    <th>Cantidad a enviar</th>
                </tr>
            </thead>
            <tbody>
                @forelse($ordenes as $orden)
                    <tr>
                        <td>{{ $orden->nombre }}</td>
                        <td>{{ $orden->codigo }}</td>
                        <!-- Mostrar la cantidad actual desde el producto relacionado -->
                        <td>
                            @if($orden->producto)
                                {{ $orden->producto->cantidad }}
                            @else
                                <span class="text-danger">Sin producto</span>
                            @endif
                        </td>
                        <td>{{ $orden->minimo }}</td>
                        <td>{{ $orden->maximo }}</td>
                        <td>${{ number_format($orden->precio, 2) }}</td>
                        <td>
                            @if($orden->descripcion)
                                {{ $orden->descripcion }}
                            @elseif($orden->producto && $orden->producto->descripcion)
                                {{ $orden->producto->descripcion }}
                            @else
                                <span class="text-muted">Sin descripción</span>
                            @endif
                        </td>
                        <td>
                            @php
                                $imagenPath = null;
                                if($orden->imagen){
                                    $imagenPath = $orden->imagen;
                                } elseif($orden->producto && $orden->producto->imagen){
                                    $imagenPath = $orden->producto->imagen;
                                }
                            @endphp
                            @if($imagenPath)
                                <img src="{{ asset('storage/' . $imagenPath) }}" width="50" alt="Imagen producto">
                            @else
                                <span class="text-muted">Sin imagen</span>
                            @endif
                        </td>
                        <td>
                            <input type="number" class="form-control" name="cantidades[{{ $orden->id }}]" min="0" placeholder="Cantidad" value="0">
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="9">No hay órdenes generadas.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
        @if($ordenes->count() > 0)
            <div class="text-end">
                <button class="btn btn-success" type="submit">Orden actualizada</button>
            </div>
        @endif
    </form>

    <div>
        {{ $ordenes->links() }}
    </div>
</div>
@endsection