<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMetodoPagoYPagaConToDetalleVentasTable extends Migration
{
    public function up()
    {
        Schema::table('detalle_ventas', function (Blueprint $table) {
            $table->string('metodo_pago')->after('total_final')->nullable();
            $table->decimal('paga_con', 10, 2)->nullable()->after('metodo_pago');
        });
    }

    public function down()
    {
        Schema::table('detalle_ventas', function (Blueprint $table) {
            $table->dropColumn(['metodo_pago', 'paga_con']);
        });
    }
}
