<?php
// Script para verificar si el almacenamiento de Laravel funciona
try {
    $testFile = 'test_' . time() . '.txt';
    Storage::disk('public')->put($testFile, 'Prueba de escritura en storage/app/public');
    if (Storage::disk('public')->exists($testFile)) {
        echo "Éxito: El archivo $testFile se creó correctamente en storage/app/public.\n";
        echo "Ruta pública: " . asset('storage/' . $testFile) . "\n";
        // Eliminar el archivo de prueba
        Storage::disk('public')->delete($testFile);
    } else {
        echo "Error: No se pudo verificar la existencia del archivo $testFile.\n";
    }
} catch (\Exception $e) {
    echo "Error al intentar escribir en storage/app/public: " . $e->getMessage() . "\n";
}
?>