<?php $__env->startSection('title', 'Inventario de Productos'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <h1>Inventario de Productos</h1>

        
        <form method="GET" action="<?php echo e(route('productos.index')); ?>" class="row g-3 align-items-end mb-4">
            <div class="col-auto">
                <label for="search" class="form-label mb-0">Buscar Producto</label>
                <input type="text" name="search" id="search" class="form-control"
                       value="<?php echo e(request('search')); ?>" placeholder="Nombre, código, marca...">
            </div>
            <div class="col-auto">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search"></i> Buscar
                </button>
                <a href="<?php echo e(route('productos.index')); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-x-circle"></i> Limpiar
                </a>
            </div>
        </form>

        
        <div class="mb-3 d-flex justify-content-start align-items-center">
            <?php if(Auth::user() && Auth::user()->role === 'administrador'): ?>
                <a href="<?php echo e(route('productos.create')); ?>" class="btn btn-success me-2">
                    <i class="bi bi-plus-circle"></i> Nuevo Producto
                </a>
            <?php endif; ?>
            <a href="<?php echo e(route('inventario.exportarExcel')); ?>" class="btn btn-success">
                <i class="bi bi-file-earmark-excel"></i> Exportar a Excel
            </a>
        </div>

        
        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
        <?php endif; ?>

        
        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>Imagen</th>
                        <th>ID</th>
                        <th>Nombre</th>
                        <th>Marca</th>
                        <th>Código</th>
                        <th>Cantidad</th>
                        <th>Stock mínimo</th>
                        <th>Stock máximo</th>
                        <th>Precio</th>
                        <?php if(Auth::user() && Auth::user()->role === 'administrador'): ?>
                            <th>Costo</th>
                        <?php endif; ?>
                        <th>Descripción</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="align-middle">
                                <?php if($producto->imagen): ?>
                                    <img src="<?php echo e(asset('storage/' . $producto->imagen)); ?>" alt="Imagen del producto" style="max-width: 80px; max-height: 80px;">
                                <?php else: ?>
                                    <span class="text-muted">Sin imagen</span>
                                <?php endif; ?>
                            </td>
                            <td class="align-middle"><?php echo e($producto->id); ?></td>
                            <td class="align-middle"><?php echo e($producto->nombre); ?></td>
                            <td class="align-middle"><?php echo e($producto->marca ?? '-'); ?></td>
                            <td class="align-middle"><?php echo e($producto->codigo ?? '-'); ?></td>
                            <td class="align-middle">
                                <span class="badge <?php echo e($producto->cantidad <= $producto->minimo ? 'bg-danger' : 'bg-primary'); ?>">
                                    <?php echo e($producto->cantidad); ?>

                                </span>
                            </td>
                            <td class="align-middle"><?php echo e($producto->minimo ?? '-'); ?></td>
                            <td class="align-middle"><?php echo e($producto->maximo ?? '-'); ?></td>
                            <td class="align-middle">$<?php echo e(number_format($producto->precio, 2)); ?></td>
                            <?php if(Auth::user() && Auth::user()->role === 'administrador'): ?>
                                <td class="align-middle">$<?php echo e(number_format($producto->costo, 2)); ?></td>
                            <?php endif; ?>
                            <td class="align-middle"><?php echo e(\Illuminate\Support\Str::limit($producto->descripcion, 65)); ?></td>
                            <td class="align-middle">
                                <div class="d-flex flex-wrap gap-2">
                                    <a href="<?php echo e(route('productos.show', $producto->id)); ?>" class="btn btn-info btn-sm"
                                       data-bs-toggle="tooltip" data-bs-placement="top" title="Ver Detalles">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <?php if(Auth::user() && Auth::user()->role === 'administrador'): ?>
                                        <a href="<?php echo e(route('productos.edit', $producto->id)); ?>" class="btn btn-warning btn-sm"
                                           data-bs-toggle="tooltip" data-bs-placement="top" title="Editar">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <form action="<?php echo e(route('productos.destroy', $producto->id)); ?>" method="POST"
                                              onsubmit="return confirm('¿Estás seguro de que quieres eliminar este producto?');" style="display:inline;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm"
                                                    data-bs-toggle="tooltip" data-bs-placement="top" title="Eliminar">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                    
                                    <?php if($producto->cantidad > 0): ?>
                                        <form action="<?php echo e(route('carrito.store')); ?>" method="POST" class="d-flex align-items-center" >
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="producto_id" value="<?php echo e($producto->id); ?>">
                                            <input type="number" name="cantidad" value="1" min="1" max="<?php echo e($producto->cantidad); ?>" style="width:60px;margin-right:5px;" class="form-control form-control-sm" required>
                                            <button type="submit" class="btn btn-primary btn-sm">
                                                <i class="bi bi-cart-plus"></i>
                                            </button>
                                        </form>
                                    <?php else: ?>
                                        <span class="badge bg-secondary text-white">Sin stock</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="<?php if(Auth::user() && Auth::user()->role === 'administrador'): ?>12 <?php else: ?> 11 <?php endif; ?>" class="text-center">
                                No hay productos registrados.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        
        <div class="d-flex justify-content-center mt-4">
            <?php echo e($productos->appends(request()->query())->links('vendor.pagination.bootstrap-5')); ?>

        </div>

        <script>
            // Inicializar tooltips de Bootstrap
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            })
        </script>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/herbalsolutionsh/public_html/inv.herbalsolutionshealth.com/resources/views/productos/index.blade.php ENDPATH**/ ?>