<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Órdenes</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            margin: 20px;
        }
        h1 {
            text-align: center;
            color: #333;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .badge {
            padding: 5px 10px;
            border-radius: 12px;
            color: white;
            font-size: 10px;
        }
        .bg-danger {
            background-color: #dc3545;
        }
        .bg-primary {
            background-color: #0d6efd;
        }
        .no-ordenes {
            text-align: center;
            margin-top: 30px;
            font-size: 16px;
            color: #888;
        }
        .footer {
            margin-top: 40px;
            font-size: 11px;
            text-align: right;
        }
    </style>
</head>
<body>
    <h1>Órdenes generadas por stock mínimo</h1>
    <table>
        <thead>
            <tr>
                <th>Producto</th>
                <th>Código</th>
                <th>Cantidad actual</th>
                <th>Stock mínimo</th>
                <th>Stock máximo</th>
                <th>Cantidad a pedir</th>
                <th>Precio</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $ordenes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orden): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($orden->nombre); ?></td>
                    <td><?php echo e($orden->codigo); ?></td>
                    <td>
                        <?php if($orden->producto): ?>
                            <span class="badge <?php echo e(($orden->producto->cantidad <= $orden->producto->minimo) ? 'bg-danger' : 'bg-primary'); ?>">
                                <?php echo e($orden->producto->cantidad); ?>

                            </span>
                        <?php else: ?>
                            <span class="badge bg-secondary">Sin producto</span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($orden->minimo); ?></td>
                    <td><?php echo e($orden->maximo); ?></td>
                    <td>
                        <?php if($orden->producto): ?>
                            <?php
                                $cantidad_a_pedir = max(0, $orden->maximo - $orden->producto->cantidad);
                            ?>
                            <?php echo e($cantidad_a_pedir); ?>

                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </td>
                    <td>$<?php echo e(number_format($orden->precio, 2)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="no-ordenes">No hay órdenes generadas.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
    <p class="footer">
        Generado el <?php echo e(now()->format('d/m/Y H:i')); ?>

    </p>
</body>
</html><?php /**PATH /home/herbalsolutionsh/public_html/inv.herbalsolutionshealth.com/resources/views/ordenes/pdf.blade.php ENDPATH**/ ?>