<?php $__env->startSection('title', 'Mi Carrito'); ?>

<?php $__env->startSection('content'); ?>
    <h1>Mi Carrito</h1>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <?php if($carrito->isEmpty()): ?>
        <div class="alert alert-info">Tu carrito está vacío.</div>
    <?php else: ?>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Producto</th>
                    <th>Precio</th>
                    <th>Cantidad</th>
                    <th>Subtotal</th>
                    <th>Descuento</th>
                    <th>Total con Descuento</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php $total = 0; ?>
                <?php $__currentLoopData = $carrito; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php 
                        $subtotal = $item->producto->precio * $item->cantidad; 
                        $total += $subtotal; 
                    ?>
                    <tr>
                        <td><?php echo e($item->producto->nombre); ?></td>
                        <td>$<?php echo e(number_format($item->producto->precio, 2)); ?></td>
                        <td>
                            <form action="<?php echo e(route('carrito.update', $item->id)); ?>" method="POST" class="d-flex align-items-center">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PATCH'); ?>
                                <input type="number" name="cantidad" value="<?php echo e($item->cantidad); ?>" 
                                        min="1" max="<?php echo e($item->producto->cantidad); ?>" 
                                        class="form-control form-control-sm" style="width: 70px;">
                                <button type="submit" class="btn btn-success btn-sm ms-2">Actualizar</button>
                            </form>
                        </td>
                        <td>$<?php echo e(number_format($subtotal, 2)); ?></td>
                        <td>
                            <div class="input-group mb-2">
                                <input type="number" name="descuento_producto[<?php echo e($item->producto->id); ?>]" 
                                        class="form-control form-control-sm" placeholder="0" min="0"
                                        value="<?php echo e(old("descuento_producto.{$item->producto->id}", 0)); ?>" form="procesar-form">
                                <select name="tipo_descuento_producto[<?php echo e($item->producto->id); ?>]" 
                                         class="form-select form-select-sm" form="procesar-form">
                                    <option value="fijo" <?php echo e(old("tipo_descuento_producto.{$item->producto->id}", 'fijo') == 'fijo' ? 'selected' : ''); ?>>$</option>
                                    <option value="porcentaje" <?php echo e(old("tipo_descuento_producto.{$item->producto->id}") == 'porcentaje' ? 'selected' : ''); ?>>%</option>
                                </select>
                            </div>
                        </td>
                        <td>$<?php echo e(number_format($subtotal, 2)); ?></td>
                        <td>
                            <form action="<?php echo e(route('carrito.destroy', $item->id)); ?>" method="POST" style="display:inline;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button class="btn btn-danger btn-sm" onclick="return confirm('¿Eliminar este producto del carrito?')">Eliminar</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <tr>
                    <td colspan="3" class="text-end align-middle"><strong>Total:</strong></td>
                    <td class="align-middle"><strong>$<?php echo e(number_format($total, 2)); ?></strong></td>
                    <td class="text-end align-middle"><strong>Descuento general:</strong></td>
                    <td colspan="2">
                        <form action="<?php echo e(route('ventas.confirmar')); ?>" method="POST" id="procesar-form">
                            <?php echo csrf_field(); ?>
                            <div class="input-group mb-2">
                                <input type="number" name="descuento_general" id="descuento_general" 
                                        class="form-control form-control-sm" placeholder="0" min="0"
                                        value="<?php echo e(old('descuento_general', 0)); ?>">
                                <select name="tipo_descuento_general" id="tipo_descuento_general" 
                                         class="form-select form-select-sm">
                                    <option value="fijo" <?php echo e(old('tipo_descuento_general', 'fijo') == 'fijo' ? 'selected' : ''); ?>>$</option>
                                    <option value="porcentaje" <?php echo e(old('tipo_descuento_general') == 'porcentaje' ? 'selected' : ''); ?>>%</option>
                                </select>
                            </div>
                    </td>
                </tr>

                <tr>
                    <td colspan="3" class="text-end align-middle"><strong>Método de Pago:</strong></td>
                    <td class="align-middle">
                        <select name="metodo_pago" id="metodo_pago" class="form-select form-select-sm" required form="procesar-form">
                            <option value="" disabled selected>Seleccione una opción</option>
                            <option value="Visa" <?php echo e(old('metodo_pago') == 'Visa' ? 'selected' : ''); ?>>Visa</option>
                            <option value="Zelle" <?php echo e(old('metodo_pago') == 'Zelle' ? 'selected' : ''); ?>>Zelle</option>
                            <option value="Cash" <?php echo e(old('metodo_pago') == 'Cash' ? 'selected' : ''); ?>>Cash</option>
                        </select>
                    </td>
                    <td class="text-end align-middle"><strong>Paga con:</strong></td>
                    <td class="align-middle" colspan="2">
                        <input type="number" name="paga_con" id="paga_con" class="form-control form-control-sm" placeholder="0.00" min="0" step="0.01" form="procesar-form" disabled>
                    </td>
                </tr>

                <tr>
                    <td colspan="5"></td>
                    <td colspan="2">
                        <button type="submit" class="btn btn-primary btn-sm w-100" form="procesar-form">Procesar Venta</button>
                        </form>
                    </td>
                </tr>
            </tbody>
        </table>
    <?php endif; ?>

    <?php if(!$carrito->isEmpty()): ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const metodoPago = document.getElementById('metodo_pago');
            const pagaCon = document.getElementById('paga_con');
            const procesarForm = document.getElementById('procesar-form');
            const totalVenta = <?php echo e(number_format($total, 2, '.', '')); ?>; // Obtenemos el total de Laravel

            function togglePagaCon() {
                if (metodoPago.value === 'Cash') {
                    pagaCon.removeAttribute('disabled');
                    pagaCon.setAttribute('required', 'required');
                    pagaCon.focus();
                } else {
                    pagaCon.value = '';
                    pagaCon.removeAttribute('required');
                    pagaCon.setAttribute('disabled', 'disabled');
                }
            }
            
            function validarVentaCash(event) {
                if (metodoPago.value === 'Cash') {
                    const montoPagado = parseFloat(pagaCon.value);
                    if (montoPagado < totalVenta) {
                        event.preventDefault(); // Detenemos el envío del formulario
                        alert('Error: El monto pagado no puede ser menor al total de la venta.');
                        pagaCon.focus();
                    }
                }
            }

            // Inicializamos estado al cargar la página
            togglePagaCon();

            // Escuchamos cambios en el método de pago
            metodoPago.addEventListener('change', togglePagaCon);
            
            // Agregamos el listener para la validación al enviar el formulario
            procesarForm.addEventListener('submit', validarVentaCash);
        });
    </script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/herbalsolutionsh/public_html/inv.herbalsolutionshealth.com/resources/views/carrito/index.blade.php ENDPATH**/ ?>