<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title><?php echo $__env->yieldContent('title', 'Inventario'); ?></title>
    <link rel="icon" type="image/png" href="<?php echo e(asset('logo.png')); ?>">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <style>
        .navbar .btn .bi {
            font-size: 1.15rem;
            vertical-align: -0.125em;
        }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-light bg-light mb-4">
    <div class="container">
        <a class="navbar-brand d-flex align-items-center" href="<?php echo e(route('productos.index')); ?>">
            <img src="<?php echo e(asset('logo.png')); ?>" alt="Logo" style="height: 32px; width: 32px; margin-right:8px;">
            Inventario
        </a>
        <div class="d-flex align-items-center">
            <?php if(Auth::check()): ?>
                <a href="<?php echo e(route('productos.index')); ?>" class="btn btn-outline-secondary me-2">
                    <i class="bi bi-box-seam me-1"></i>
                    Inventario
                </a>
                <?php if(Auth::user()->role === 'administrador'): ?>
                    <a href="<?php echo e(route('ordenes.index')); ?>" class="btn btn-outline-warning me-2">
                        <i class="bi bi-truck me-1"></i>
                        Órdenes
                    </a>
                <?php endif; ?>
                <a href="<?php echo e(route('ventas.index')); ?>" class="btn btn-outline-primary me-2">
                    <i class="bi bi-receipt me-1"></i>
                    Historial de ventas
                </a>

                
                <a href="<?php echo e(route('carrito.index')); ?>" class="btn btn-outline-success position-relative me-2">
                    <i class="bi bi-cart me-1"></i>
                    Carrito
                    <?php
                        $carritoCantidad = \App\Models\Carrito::where('user_id', auth()->id())->sum('cantidad');
                    ?>
                    <?php if($carritoCantidad > 0): ?>
                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                            <?php echo e($carritoCantidad); ?>

                        </span>
                    <?php endif; ?>
                </a>

                <form action="<?php echo e(route('logout')); ?>" method="POST" style="display:inline;">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-outline-danger">
                        <i class="bi bi-box-arrow-right me-1"></i>
                        Cerrar sesión
                    </button>
                </form>
            <?php endif; ?>
        </div>
    </div>
</nav>
<div class="container">
    <?php echo $__env->yieldContent('content'); ?>
</div>
</body>
</html><?php /**PATH /home/herbalsolutionsh/public_html/inv.herbalsolutionshealth.com/resources/views/layouts/app.blade.php ENDPATH**/ ?>