<?php $__env->startSection('title', 'Historial de Ventas'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="my-4">
            <h1>Historial de Ventas</h1>
        </div>

        
        <?php if(request('busqueda') || request('fecha_inicio') || request('fecha_fin')): ?>
            <div class="row mb-4">
                <div class="col-md-4 mx-auto">
                    <div class="card text-center bg-primary text-white shadow-lg">
                        <div class="card-header">
                            Total de Ventas
                        </div>
                        <div class="card-body">
                            <h3 class="card-title">$<?php echo e(number_format($totalVentas, 2)); ?></h3>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        
        <form method="GET" action="<?php echo e(route('ventas.index')); ?>" class="row g-3 align-items-end mb-4">
            <div class="col-md-4 col-lg-auto">
                <label for="busqueda" class="form-label mb-0">Buscar</label>
                <input type="text" name="busqueda" id="busqueda" class="form-control"
                        value="<?php echo e(request('busqueda')); ?>" placeholder="ID Venta, Vendedor...">
            </div>
            <div class="col-md-4 col-lg-auto">
                <label for="fecha_inicio" class="form-label mb-0">Fecha inicio</label>
                <input type="date" name="fecha_inicio" id="fecha_inicio" class="form-control"
                        value="<?php echo e(request('fecha_inicio', '')); ?>">
            </div>
            <div class="col-md-4 col-lg-auto">
                <label for="fecha_fin" class="form-label mb-0">Fecha fin</label>
                <input type="date" name="fecha_fin" id="fecha_fin" class="form-control"
                        value="<?php echo e(request('fecha_fin', '')); ?>">
            </div>
            <div class="col-md-12 col-lg-auto d-flex justify-content-end">
                <button type="submit" class="btn btn-primary me-2">
                    <i class="bi bi-search"></i>
                    Buscar
                </button>
                <a href="<?php echo e(route('ventas.index')); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-x-circle"></i>
                    Limpiar
                </a>
            </div>
        </form>

        
        <div class="d-flex mb-3">
            <a href="<?php echo e(route('ventas.exportarPdf', request()->all())); ?>" class="btn btn-success me-2" target="_blank">
                <i class="bi bi-file-earmark-pdf"></i> Exportar a PDF
            </a>
            <a href="<?php echo e(route('ventas.exportarExcel', request()->all())); ?>" class="btn btn-success" target="_blank">
                <i class="bi bi-file-earmark-excel"></i> Exportar a Excel
            </a>
        </div>

        
        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
        <?php endif; ?>

        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>ID Venta</th>
                        <th>Vendedor</th>
                        <th>Fecha</th>
                        <th>Total</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $ventas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($venta->id); ?></td>
                            <td><?php echo e($venta->user->name ?? '-'); ?></td>
                            <td><?php echo e($venta->created_at->format('d/m/Y H:i')); ?></td>
                            <td>$<?php echo e(number_format($venta->total, 2)); ?></td>
                            <td class="d-flex justify-content-center align-items-center">
                                <a href="<?php echo e(route('ventas.show', $venta->id)); ?>" class="btn btn-sm btn-info me-2">
                                    <i class="bi bi-eye"></i> Detalles
                                </a>
                                <!-- Botones para eliminar y editar la venta, solo si el usuario es un administrador -->
                                <?php if(Auth::check() && Auth::user()->is_admin): ?>
                                <button type="button" class="btn btn-sm btn-warning me-2" data-bs-toggle="modal" data-bs-target="#editDateModal" data-id="<?php echo e($venta->id); ?>" data-date="<?php echo e($venta->created_at->format('Y-m-d\TH:i')); ?>">
                                    <i class="bi bi-pencil"></i> Editar
                                </button>
                                <form action="<?php echo e(route('ventas.destroy', $venta->id)); ?>" method="POST"
                                    onsubmit="return confirm('¿Estás seguro de que quieres eliminar esta venta? Esta acción no se puede deshacer y el stock del producto NO se devolverá al inventario.');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="bi bi-trash"></i> Eliminar
                                    </button>
                                </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5">No hay ventas registradas.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <div class="mb-2">
            Mostrando <?php echo e($ventas->firstItem()); ?> a <?php echo e($ventas->lastItem()); ?> de <?php echo e($ventas->total()); ?> resultados
        </div>
        <div class="d-flex justify-content-center mt-4">
            <?php echo e($ventas->appends(request()->query())->links('vendor.pagination.bootstrap-5')); ?>

        </div>

        <!-- Modal para editar la fecha de venta -->
        <div class="modal fade" id="editDateModal" tabindex="-1" aria-labelledby="editDateModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="editDateModalLabel">Editar Fecha de Venta</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <form id="editDateForm" action="<?php echo e(route('ventas.update-date')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                  <input type="hidden" name="venta_id" id="ventaIdInput">
                  <div class="mb-3">
                    <label for="newDateInput" class="form-label">Nueva Fecha y Hora</label>
                    <input type="datetime-local" class="form-control" id="newDateInput" name="new_date" required>
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                  <button type="submit" class="btn btn-primary">Guardar Cambios</button>
                </div>
              </form>
            </div>
          </div>
        </div>
    </div>
    
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var editDateModal = document.getElementById('editDateModal');
            if (editDateModal) {
                editDateModal.addEventListener('show.bs.modal', function(event) {
                    var button = event.relatedTarget;
                    var ventaId = button.getAttribute('data-id');
                    var ventaDate = button.getAttribute('data-date');
                    
                    var modalForm = document.getElementById('editDateForm');
                    var ventaIdInput = modalForm.querySelector('#ventaIdInput');
                    var newDateInput = modalForm.querySelector('#newDateInput');

                    if (ventaIdInput && newDateInput) {
                        ventaIdInput.value = ventaId;
                        newDateInput.value = ventaDate;
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/herbalsolutionsh/public_html/inv.herbalsolutionshealth.com/resources/views/ventas/index.blade.php ENDPATH**/ ?>