

<?php $__env->startSection('title', 'Detalle de Producto'); ?>

<?php $__env->startSection('content'); ?>
    <h1>Detalle de Producto</h1>
    <div class="row">
        <div class="col-md-4">
            <?php if($producto->imagen): ?>
                <img src="<?php echo e(asset('storage/'.$producto->imagen)); ?>" alt="Imagen" class="img-fluid rounded mb-2">
            <?php else: ?>
                <span class="text-muted">Sin imagen</span>
            <?php endif; ?>
        </div>
        <div class="col-md-8">
            <ul class="list-group">
                <li class="list-group-item"><b>ID:</b> <?php echo e($producto->id); ?></li>
                <li class="list-group-item"><b>Código:</b>
                    <?php if($producto->codigo): ?>
                        <?php echo e($producto->codigo); ?>

                    <?php else: ?>
                        <span class="text-muted">-</span>
                    <?php endif; ?>
                </li>
                <li class="list-group-item"><b>Nombre:</b> <?php echo e($producto->nombre); ?></li>
                <!-- Campo marca -->
                <li class="list-group-item"><b>Marca:</b>
                    <?php if($producto->marca): ?>
                        <?php echo e($producto->marca); ?>

                    <?php else: ?>
                        <span class="text-muted">-</span>
                    <?php endif; ?>
                </li>
                <li class="list-group-item"><b>Cantidad:</b> <?php echo e($producto->cantidad); ?></li>
                <li class="list-group-item"><b>Stock mínimo:</b>
                    <?php if(isset($producto->stock_minimo)): ?>
                        <?php echo e($producto->stock_minimo); ?>

                    <?php elseif(isset($producto->minimo)): ?>
                        <?php echo e($producto->minimo); ?>

                    <?php else: ?>
                        <span class="text-muted">-</span>
                    <?php endif; ?>
                </li>
                <li class="list-group-item"><b>Stock máximo:</b>
                    <?php if(isset($producto->stock_maximo)): ?>
                        <?php echo e($producto->stock_maximo); ?>

                    <?php elseif(isset($producto->maximo)): ?>
                        <?php echo e($producto->maximo); ?>

                    <?php else: ?>
                        <span class="text-muted">-</span>
                    <?php endif; ?>
                </li>
                <li class="list-group-item"><b>Precio:</b> $<?php echo e(number_format($producto->precio, 2)); ?></li>
                <?php if(Auth::user() && Auth::user()->role === 'administrador'): ?>
                    <li class="list-group-item"><b>Costo:</b>
                        <?php if($producto->costo !== null): ?>
                            $<?php echo e(number_format($producto->costo, 2)); ?>

                        <?php else: ?>
                            <span class="text-muted">-</span>
                        <?php endif; ?>
                    </li>
                <?php endif; ?>
                <li class="list-group-item"><b>Descripción:</b> <?php echo e($producto->descripcion); ?></li>
            </ul>
        </div>
    </div>
    <a href="<?php echo e(route('productos.index')); ?>" class="btn btn-secondary mt-3">Volver</a>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/herbalsolutionsh/public_html/inv.herbalsolutionshealth.com/resources/views/productos/show.blade.php ENDPATH**/ ?>