

<?php $__env->startSection('title', 'Detalle de Venta'); ?>

<?php $__env->startSection('content'); ?>
    
    <style>
        @media print {
            body {
                margin: 0;
            }
            .navbar,
            .sidebar-menu,
            .btn.d-print-none,
            .btn-secondary.d-print-none,
            .content-header,
            footer {
                display: none !important;
            }
            .content-wrapper {
                margin-left: 0 !important;
                padding-top: 0 !important;
            }
            .container-fluid {
                padding: 0 !important;
            }
        }
    </style>

    
    <div class="d-flex justify-content-between align-items-center mb-4 d-print-none">
        <h1 class="d-none">Detalle de Venta #<?php echo e($venta->id); ?></h1>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> Imprimir Comprobante
        </button>
    </div>

    
    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    
    <div class="comprobante-imprimir">
        
        <h1>Detalle de Venta #<?php echo e($venta->id); ?></h1>
        <?php
            $totalSinDescuento = $venta->detalles->sum(fn($detalle) => $detalle->cantidad * $detalle->precio);
            $totalFinal = $venta->total;
            $primerDetalle = $venta->detalles->first();
            $metodoPago = $primerDetalle->metodo_pago ?? '-';
            $pagaCon = $primerDetalle->paga_con ?? null;
            $vuelto = $primerDetalle->vuelto ?? null;
        ?>

        <div class="mb-3">
            <strong>Vendedor:</strong> <?php echo e($venta->user->name ?? '-'); ?><br>
            <strong>Fecha:</strong> <?php echo e($venta->created_at->format('d/m/Y H:i')); ?><br>
            <strong>Método de Pago:</strong> <?php echo e($metodoPago); ?><br>
            <?php if($metodoPago === 'Cash' && $pagaCon): ?>
                <strong>Paga con:</strong> $<?php echo e(number_format($pagaCon, 2)); ?><br>
                <strong>Vuelto:</strong> $<?php echo e(number_format($vuelto, 2)); ?><br>
            <?php endif; ?>
            <strong>Total sin descuento:</strong> $<?php echo e(number_format($totalSinDescuento, 2)); ?><br>
            <strong>Total con descuento general:</strong> $<?php echo e(number_format($totalFinal, 2)); ?>

        </div>

        <h4>Productos vendidos:</h4>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Producto</th>
                    <th>Código</th>
                    <th class="text-end">Cantidad</th>
                    <th class="text-end">Precio Unitario</th>
                    <th class="text-end">Descuento</th>
                    
                    <?php if(Auth::check()): ?>
                        <th class="d-print-none">Devolver</th>
                    <?php endif; ?>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $venta->detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $subtotal = $detalle->cantidad * $detalle->precio;
                        $descuento = $detalle->descuento_individual ?? 0;
                        $tipo = $detalle->tipo_descuento_individual ?? 'fijo';
                    ?>
                    <tr>
                        <td><?php echo e($detalle->producto->nombre ?? '-'); ?></td>
                        <td><?php echo e($detalle->producto->codigo ?? '-'); ?></td>
                        <td class="text-end"><?php echo e($detalle->cantidad); ?></td>
                        <td class="text-end">$<?php echo e(number_format($detalle->precio, 2)); ?></td>
                        <td class="text-end">$<?php echo e(number_format($detalle->descuento, 2)); ?></td>
                        
                        <?php if(Auth::check()): ?>
                            <td class="d-print-none">
                                <form action="<?php echo e(route('ventas.devolver', $venta->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="detalle_id" value="<?php echo e($detalle->id); ?>">
                                    <div class="input-group">
                                        <input type="number" name="cantidad_devolver" class="form-control form-control-sm"
                                               value="1" min="1" max="<?php echo e($detalle->cantidad); ?>" required>
                                        <button type="submit" class="btn btn-warning btn-sm">
                                            <i class="bi bi-arrow-return-left"></i>
                                        </button>
                                    </div>
                                </form>
                            </td>
                        <?php endif; ?>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <?php
            $infoDescuentos = json_decode($venta->descuentos, true);
            $descuentoGeneral = $infoDescuentos['general']['monto'] ?? 0;
            $tipoDescuentoGeneral = $infoDescuentos['general']['tipo'] ?? 'fijo';
        ?>

        <?php if($descuentoGeneral > 0): ?>
            <div class="alert alert-info">
                <strong>Descuento General Aplicado:</strong>
                <?php if($tipoDescuentoGeneral === 'porcentaje' && $totalSinDescuento > 0): ?>
                    <?php echo e(number_format(($descuentoGeneral / $totalSinDescuento) * 100, 2)); ?> %
                <?php else: ?>
                    $<?php echo e(number_format($descuentoGeneral, 2)); ?>

                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>

    
    <a href="<?php echo e(route('productos.index')); ?>" class="btn btn-secondary d-print-none">Volver</a>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/herbalsolutionsh/public_html/inv.herbalsolutionshealth.com/resources/views/ventas/show.blade.php ENDPATH**/ ?>