

<?php $__env->startSection('title', 'Confirmar Venta con Descuentos'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <h1 class="mb-4">Confirmar Venta</h1>

    <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <?php
        // ¡Asegúrate de que este valor SIEMPRE venga del request, nunca 'No seleccionado'!
        $metodoPagoSeleccionado = $metodoPagoSeleccionado ?? '';
        $pagaCon = $pagaCon ?? null;
        $vuelto = ($metodoPagoSeleccionado === 'Cash' && is_numeric($pagaCon)) ? ($pagaCon - $totalConDescuento) : null;
    ?>

    <div class="card mb-4">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Producto</th>
                            <th class="text-end">Precio Unitario</th>
                            <th class="text-end">Cantidad</th>
                            <th class="text-end">Subtotal</th>
                            <th class="text-end">Descuento</th>
                            <th class="text-end">Total Producto</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $carrito; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $productoId = $item->producto->id;
                                $subtotal = $item->producto->precio * $item->cantidad;
                                $descuento = $descuentos['productos'][$productoId]['monto'] ?? 0;
                                $tipoDescuento = $descuentos['productos'][$productoId]['tipo'] ?? 'fijo';
                                $totalProducto = max($subtotal - $descuento, 0);
                                $porcentajeDescuento = $subtotal > 0 ? ($descuento / $subtotal) * 100 : 0;
                            ?>
                            <tr>
                                <td><?php echo e($item->producto->nombre); ?></td>
                                <td class="text-end">$<?php echo e(number_format($item->producto->precio, 2)); ?></td>
                                <td class="text-end"><?php echo e($item->cantidad); ?></td>
                                <td class="text-end">$<?php echo e(number_format($subtotal, 2)); ?></td>
                                <td class="text-end">
                                    <?php if($tipoDescuento == 'porcentaje'): ?>
                                        <?php echo e(number_format($porcentajeDescuento, 2)); ?> %
                                    <?php else: ?>
                                        $<?php echo e(number_format($descuento, 2)); ?>

                                    <?php endif; ?>
                                </td>
                                <td class="text-end">$<?php echo e(number_format($totalProducto, 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <?php
                            $porcentajeDescuentoGeneral = $total > 0 ? ($descuentos['general']['monto'] / $total) * 100 : 0;
                        ?>
                        <tr class="table-active">
                            <td colspan="3" class="text-end"><strong>Subtotal:</strong></td>
                            <td colspan="3" class="text-end"><strong>$<?php echo e(number_format($total, 2)); ?></strong></td>
                        </tr>
                        <tr class="table-active">
                            <td colspan="3" class="text-end"><strong>Descuento General:</strong></td>
                            <td colspan="3" class="text-end">
                                <strong>
                                    <?php if($descuentos['general']['tipo'] == 'porcentaje'): ?>
                                        <?php echo e(number_format($porcentajeDescuentoGeneral, 2)); ?> %
                                    <?php else: ?>
                                        $<?php echo e(number_format($descuentos['general']['monto'], 2)); ?>

                                    <?php endif; ?>
                                </strong>
                            </td>
                        </tr>

                        <tr class="table-active">
                            <td colspan="3" class="text-end"><strong>Método de Pago:</strong></td>
                            <td colspan="3" class="text-end">
                                <strong>
                                    <?php if($metodoPagoSeleccionado): ?>
                                        <?php echo e($metodoPagoSeleccionado); ?>

                                    <?php else: ?>
                                        No seleccionado
                                    <?php endif; ?>
                                </strong>
                            </td>
                        </tr>

                        <tr class="table-success">
                            <td colspan="3" class="text-end"><strong>Total a Pagar:</strong></td>
                            <td colspan="3" class="text-end"><strong>$<?php echo e(number_format($totalConDescuento, 2)); ?></strong></td>
                        </tr>

                        <?php if($metodoPagoSeleccionado === 'Cash' && is_numeric($pagaCon)): ?>
                        <tr class="table-info">
                            <td colspan="3" class="text-end"><strong>Paga con:</strong></td>
                            <td colspan="3" class="text-end"><strong>$<?php echo e(number_format($pagaCon, 2)); ?></strong></td>
                        </tr>
                        <tr class="table-warning">
                            <td colspan="3" class="text-end"><strong>Vuelto:</strong></td>
                            <td colspan="3" class="text-end"><strong>$<?php echo e(number_format($vuelto, 2)); ?></strong></td>
                        </tr>
                        <?php endif; ?>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <div class="d-flex justify-content-between">
        <a href="<?php echo e(route('carrito.index')); ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i> Volver al Carrito
        </a>

        <form action="<?php echo e(route('ventas.procesar')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <?php $__currentLoopData = $carrito; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <input type="hidden" name="descuento_producto[<?php echo e($item->producto->id); ?>]"
                       value="<?php echo e($descuentos['productos'][$item->producto->id]['monto'] ?? 0); ?>">
                <input type="hidden" name="tipo_descuento_producto[<?php echo e($item->producto->id); ?>]"
                       value="<?php echo e($descuentos['productos'][$item->producto->id]['tipo'] ?? 'fijo'); ?>">
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <input type="hidden" name="descuento_general" value="<?php echo e($descuentos['general']['monto'] ?? 0); ?>">
            <input type="hidden" name="tipo_descuento_general" value="<?php echo e($descuentos['general']['tipo'] ?? 'fijo'); ?>">
            <input type="hidden" name="total_con_descuento" value="<?php echo e($totalConDescuento); ?>">
            <input type="hidden" name="metodo_pago" value="<?php echo e($metodoPagoSeleccionado); ?>">
            <input type="hidden" name="paga_con" value="<?php echo e($pagaCon); ?>">
            <input type="hidden" name="vuelto" value="<?php echo e($vuelto); ?>">

            <button type="submit" class="btn btn-success">
                <i class="fas fa-check-circle me-2"></i> Confirmar Venta
            </button>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/herbalsolutionsh/public_html/inv.herbalsolutionshealth.com/resources/views/ventas/confirmar.blade.php ENDPATH**/ ?>