@extends('layouts.app')

@section('title', 'Detalle de Venta')

@section('content')
    {{-- Estilos para la impresión --}}
    <style>
        @media print {
            body {
                margin: 0;
            }
            .navbar,
            .sidebar-menu,
            .btn.d-print-none,
            .btn-secondary.d-print-none,
            .content-header,
            footer {
                display: none !important;
            }
            .content-wrapper {
                margin-left: 0 !important;
                padding-top: 0 !important;
            }
            .container-fluid {
                padding: 0 !important;
            }
        }
    </style>

    {{-- Botón de impresión que se oculta al imprimir --}}
    <div class="d-flex justify-content-between align-items-center mb-4 d-print-none">
        <h1 class="d-none">Detalle de Venta #{{ $venta->id }}</h1>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> Imprimir Comprobante
        </button>
    </div>

    {{-- Mensajes de éxito o error --}}
    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    {{-- Contenido del comprobante que se imprimirá --}}
    <div class="comprobante-imprimir">
        {{-- Título que se mostrará en la impresión --}}
        <h1>Detalle de Venta #{{ $venta->id }}</h1>
        @php
            $totalSinDescuento = $venta->detalles->sum(fn($detalle) => $detalle->cantidad * $detalle->precio);
            $totalFinal = $venta->total;
            $primerDetalle = $venta->detalles->first();
            $metodoPago = $primerDetalle->metodo_pago ?? '-';
            $pagaCon = $primerDetalle->paga_con ?? null;
            $vuelto = $primerDetalle->vuelto ?? null;
        @endphp

        <div class="mb-3">
            <strong>Vendedor:</strong> {{ $venta->user->name ?? '-' }}<br>
            <strong>Fecha:</strong> {{ $venta->created_at->format('d/m/Y H:i') }}<br>
            <strong>Método de Pago:</strong> {{ $metodoPago }}<br>
            @if($metodoPago === 'Cash' && $pagaCon)
                <strong>Paga con:</strong> ${{ number_format($pagaCon, 2) }}<br>
                <strong>Vuelto:</strong> ${{ number_format($vuelto, 2) }}<br>
            @endif
            <strong>Total sin descuento:</strong> ${{ number_format($totalSinDescuento, 2) }}<br>
            <strong>Total con descuento general:</strong> ${{ number_format($totalFinal, 2) }}
        </div>

        <h4>Productos vendidos:</h4>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Producto</th>
                    <th>Código</th>
                    <th class="text-end">Cantidad</th>
                    <th class="text-end">Precio Unitario</th>
                    <th class="text-end">Descuento</th>
                    {{-- Nueva columna para la devolución, oculta en la impresión. Ahora visible para todos los usuarios autenticados --}}
                    @if(Auth::check())
                        <th class="d-print-none">Devolver</th>
                    @endif
                </tr>
            </thead>
            <tbody>
                @foreach($venta->detalles as $detalle)
                    @php
                        $subtotal = $detalle->cantidad * $detalle->precio;
                        $descuento = $detalle->descuento_individual ?? 0;
                        $tipo = $detalle->tipo_descuento_individual ?? 'fijo';
                    @endphp
                    <tr>
                        <td>{{ $detalle->producto->nombre ?? '-' }}</td>
                        <td>{{ $detalle->producto->codigo ?? '-' }}</td>
                        <td class="text-end">{{ $detalle->cantidad }}</td>
                        <td class="text-end">${{ number_format($detalle->precio, 2) }}</td>
                        <td class="text-end">${{ number_format($detalle->descuento, 2) }}</td>
                        {{-- Formulario para la devolución, visible para cualquier usuario autenticado --}}
                        @if(Auth::check())
                            <td class="d-print-none">
                                <form action="{{ route('ventas.devolver', $venta->id) }}" method="POST">
                                    @csrf
                                    <input type="hidden" name="detalle_id" value="{{ $detalle->id }}">
                                    <div class="input-group">
                                        <input type="number" name="cantidad_devolver" class="form-control form-control-sm"
                                               value="1" min="1" max="{{ $detalle->cantidad }}" required>
                                        <button type="submit" class="btn btn-warning btn-sm">
                                            <i class="bi bi-arrow-return-left"></i>
                                        </button>
                                    </div>
                                </form>
                            </td>
                        @endif
                    </tr>
                @endforeach
            </tbody>
        </table>

        @php
            $infoDescuentos = json_decode($venta->descuentos, true);
            $descuentoGeneral = $infoDescuentos['general']['monto'] ?? 0;
            $tipoDescuentoGeneral = $infoDescuentos['general']['tipo'] ?? 'fijo';
        @endphp

        @if($descuentoGeneral > 0)
            <div class="alert alert-info">
                <strong>Descuento General Aplicado:</strong>
                @if($tipoDescuentoGeneral === 'porcentaje' && $totalSinDescuento > 0)
                    {{ number_format(($descuentoGeneral / $totalSinDescuento) * 100, 2) }} %
                @else
                    ${{ number_format($descuentoGeneral, 2) }}
                @endif
            </div>
        @endif
    </div>

    {{-- Botón para volver que no se mostrará en la impresión --}}
    <a href="{{ route('productos.index') }}" class="btn btn-secondary d-print-none">Volver</a>
@endsection
