@extends('layouts.app')

@section('title', 'Confirmar Venta con Descuentos')

@section('content')
<div class="container">
    <h1 class="mb-4">Confirmar Venta</h1>

    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    @php
        // ¡Asegúrate de que este valor SIEMPRE venga del request, nunca 'No seleccionado'!
        $metodoPagoSeleccionado = $metodoPagoSeleccionado ?? '';
        $pagaCon = $pagaCon ?? null;
        $vuelto = ($metodoPagoSeleccionado === 'Cash' && is_numeric($pagaCon)) ? ($pagaCon - $totalConDescuento) : null;
    @endphp

    <div class="card mb-4">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Producto</th>
                            <th class="text-end">Precio Unitario</th>
                            <th class="text-end">Cantidad</th>
                            <th class="text-end">Subtotal</th>
                            <th class="text-end">Descuento</th>
                            <th class="text-end">Total Producto</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($carrito as $item)
                            @php
                                $productoId = $item->producto->id;
                                $subtotal = $item->producto->precio * $item->cantidad;
                                $descuento = $descuentos['productos'][$productoId]['monto'] ?? 0;
                                $tipoDescuento = $descuentos['productos'][$productoId]['tipo'] ?? 'fijo';
                                $totalProducto = max($subtotal - $descuento, 0);
                                $porcentajeDescuento = $subtotal > 0 ? ($descuento / $subtotal) * 100 : 0;
                            @endphp
                            <tr>
                                <td>{{ $item->producto->nombre }}</td>
                                <td class="text-end">${{ number_format($item->producto->precio, 2) }}</td>
                                <td class="text-end">{{ $item->cantidad }}</td>
                                <td class="text-end">${{ number_format($subtotal, 2) }}</td>
                                <td class="text-end">
                                    @if($tipoDescuento == 'porcentaje')
                                        {{ number_format($porcentajeDescuento, 2) }} %
                                    @else
                                        ${{ number_format($descuento, 2) }}
                                    @endif
                                </td>
                                <td class="text-end">${{ number_format($totalProducto, 2) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        @php
                            $porcentajeDescuentoGeneral = $total > 0 ? ($descuentos['general']['monto'] / $total) * 100 : 0;
                        @endphp
                        <tr class="table-active">
                            <td colspan="3" class="text-end"><strong>Subtotal:</strong></td>
                            <td colspan="3" class="text-end"><strong>${{ number_format($total, 2) }}</strong></td>
                        </tr>
                        <tr class="table-active">
                            <td colspan="3" class="text-end"><strong>Descuento General:</strong></td>
                            <td colspan="3" class="text-end">
                                <strong>
                                    @if($descuentos['general']['tipo'] == 'porcentaje')
                                        {{ number_format($porcentajeDescuentoGeneral, 2) }} %
                                    @else
                                        ${{ number_format($descuentos['general']['monto'], 2) }}
                                    @endif
                                </strong>
                            </td>
                        </tr>

                        <tr class="table-active">
                            <td colspan="3" class="text-end"><strong>Método de Pago:</strong></td>
                            <td colspan="3" class="text-end">
                                <strong>
                                    @if($metodoPagoSeleccionado)
                                        {{ $metodoPagoSeleccionado }}
                                    @else
                                        No seleccionado
                                    @endif
                                </strong>
                            </td>
                        </tr>

                        <tr class="table-success">
                            <td colspan="3" class="text-end"><strong>Total a Pagar:</strong></td>
                            <td colspan="3" class="text-end"><strong>${{ number_format($totalConDescuento, 2) }}</strong></td>
                        </tr>

                        @if($metodoPagoSeleccionado === 'Cash' && is_numeric($pagaCon))
                        <tr class="table-info">
                            <td colspan="3" class="text-end"><strong>Paga con:</strong></td>
                            <td colspan="3" class="text-end"><strong>${{ number_format($pagaCon, 2) }}</strong></td>
                        </tr>
                        <tr class="table-warning">
                            <td colspan="3" class="text-end"><strong>Vuelto:</strong></td>
                            <td colspan="3" class="text-end"><strong>${{ number_format($vuelto, 2) }}</strong></td>
                        </tr>
                        @endif
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <div class="d-flex justify-content-between">
        <a href="{{ route('carrito.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i> Volver al Carrito
        </a>

        <form action="{{ route('ventas.procesar') }}" method="POST">
            @csrf

            @foreach($carrito as $item)
                <input type="hidden" name="descuento_producto[{{ $item->producto->id }}]"
                       value="{{ $descuentos['productos'][$item->producto->id]['monto'] ?? 0 }}">
                <input type="hidden" name="tipo_descuento_producto[{{ $item->producto->id }}]"
                       value="{{ $descuentos['productos'][$item->producto->id]['tipo'] ?? 'fijo' }}">
            @endforeach

            <input type="hidden" name="descuento_general" value="{{ $descuentos['general']['monto'] ?? 0 }}">
            <input type="hidden" name="tipo_descuento_general" value="{{ $descuentos['general']['tipo'] ?? 'fijo' }}">
            <input type="hidden" name="total_con_descuento" value="{{ $totalConDescuento }}">
            <input type="hidden" name="metodo_pago" value="{{ $metodoPagoSeleccionado }}">
            <input type="hidden" name="paga_con" value="{{ $pagaCon }}">
            <input type="hidden" name="vuelto" value="{{ $vuelto }}">

            <button type="submit" class="btn btn-success">
                <i class="fas fa-check-circle me-2"></i> Confirmar Venta
            </button>
        </form>
    </div>
</div>
@endsection