@extends('layouts.app')

@section('title', 'Inventario de Productos')

@section('content')
    <div class="container">
        <h1>Inventario de Productos</h1>

        {{-- Buscador --}}
        <form method="GET" action="{{ route('productos.index') }}" class="row g-3 align-items-end mb-4">
            <div class="col-auto">
                <label for="search" class="form-label mb-0">Buscar Producto</label>
                <input type="text" name="search" id="search" class="form-control"
                       value="{{ request('search') }}" placeholder="Nombre, código, marca...">
            </div>
            <div class="col-auto">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search"></i> Buscar
                </button>
                <a href="{{ route('productos.index') }}" class="btn btn-outline-secondary">
                    <i class="bi bi-x-circle"></i> Limpiar
                </a>
            </div>
        </form>

        {{-- Botones de acción --}}
        <div class="mb-3 d-flex justify-content-start align-items-center">
            @if(Auth::user() && Auth::user()->role === 'administrador')
                <a href="{{ route('productos.create') }}" class="btn btn-success me-2">
                    <i class="bi bi-plus-circle"></i> Nuevo Producto
                </a>
            @endif
            <a href="{{ route('inventario.exportarExcel') }}" class="btn btn-success">
                <i class="bi bi-file-earmark-excel"></i> Exportar a Excel
            </a>
        </div>

        {{-- Mensajes de éxito o error --}}
        @if (session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if (session('error'))
            <div class="alert alert-danger">{{ session('error') }}</div>
        @endif

        {{-- Tabla de productos --}}
        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>Imagen</th>
                        <th>ID</th>
                        <th>Nombre</th>
                        <th>Marca</th>
                        <th>Código</th>
                        <th>Cantidad</th>
                        <th>Stock mínimo</th>
                        <th>Stock máximo</th>
                        <th>Precio</th>
                        @if(Auth::user() && Auth::user()->role === 'administrador')
                            <th>Costo</th>
                        @endif
                        <th>Descripción</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($productos as $producto)
                        <tr>
                            <td class="align-middle">
                                @if($producto->imagen)
                                    <img src="{{ asset('storage/' . $producto->imagen) }}" alt="Imagen del producto" style="max-width: 80px; max-height: 80px;">
                                @else
                                    <span class="text-muted">Sin imagen</span>
                                @endif
                            </td>
                            <td class="align-middle">{{ $producto->id }}</td>
                            <td class="align-middle">{{ $producto->nombre }}</td>
                            <td class="align-middle">{{ $producto->marca ?? '-' }}</td>
                            <td class="align-middle">{{ $producto->codigo ?? '-' }}</td>
                            <td class="align-middle">
                                <span class="badge {{ $producto->cantidad <= $producto->minimo ? 'bg-danger' : 'bg-primary' }}">
                                    {{ $producto->cantidad }}
                                </span>
                            </td>
                            <td class="align-middle">{{ $producto->minimo ?? '-' }}</td>
                            <td class="align-middle">{{ $producto->maximo ?? '-' }}</td>
                            <td class="align-middle">${{ number_format($producto->precio, 2) }}</td>
                            @if(Auth::user() && Auth::user()->role === 'administrador')
                                <td class="align-middle">${{ number_format($producto->costo, 2) }}</td>
                            @endif
                            <td class="align-middle">{{ \Illuminate\Support\Str::limit($producto->descripcion, 65) }}</td>
                            <td class="align-middle">
                                <div class="d-flex flex-wrap gap-2">
                                    <a href="{{ route('productos.show', $producto->id) }}" class="btn btn-info btn-sm"
                                       data-bs-toggle="tooltip" data-bs-placement="top" title="Ver Detalles">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    @if(Auth::user() && Auth::user()->role === 'administrador')
                                        <a href="{{ route('productos.edit', $producto->id) }}" class="btn btn-warning btn-sm"
                                           data-bs-toggle="tooltip" data-bs-placement="top" title="Editar">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <form action="{{ route('productos.destroy', $producto->id) }}" method="POST"
                                              onsubmit="return confirm('¿Estás seguro de que quieres eliminar este producto?');" style="display:inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm"
                                                    data-bs-toggle="tooltip" data-bs-placement="top" title="Eliminar">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    @endif
                                    {{-- BOTÓN AGREGAR AL CARRITO --}}
                                    @if($producto->cantidad > 0)
                                        <form action="{{ route('carrito.store') }}" method="POST" class="d-flex align-items-center" >
                                            @csrf
                                            <input type="hidden" name="producto_id" value="{{ $producto->id }}">
                                            <input type="number" name="cantidad" value="1" min="1" max="{{ $producto->cantidad }}" style="width:60px;margin-right:5px;" class="form-control form-control-sm" required>
                                            <button type="submit" class="btn btn-primary btn-sm">
                                                <i class="bi bi-cart-plus"></i>
                                            </button>
                                        </form>
                                    @else
                                        <span class="badge bg-secondary text-white">Sin stock</span>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="@if(Auth::user() && Auth::user()->role === 'administrador')12 @else 11 @endif" class="text-center">
                                No hay productos registrados.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Paginación --}}
        <div class="d-flex justify-content-center mt-4">
            {{ $productos->appends(request()->query())->links('vendor.pagination.bootstrap-5') }}
        </div>

        <script>
            // Inicializar tooltips de Bootstrap
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            })
        </script>
    </div>
@endsection
