<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Órdenes</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            margin: 20px;
        }
        h1 {
            text-align: center;
            color: #333;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .badge {
            padding: 5px 10px;
            border-radius: 12px;
            color: white;
            font-size: 10px;
        }
        .bg-danger {
            background-color: #dc3545;
        }
        .bg-primary {
            background-color: #0d6efd;
        }
        .no-ordenes {
            text-align: center;
            margin-top: 30px;
            font-size: 16px;
            color: #888;
        }
        .footer {
            margin-top: 40px;
            font-size: 11px;
            text-align: right;
        }
    </style>
</head>
<body>
    <h1>Órdenes generadas por stock mínimo</h1>
    <table>
        <thead>
            <tr>
                <th>Producto</th>
                <th>Código</th>
                <th>Cantidad actual</th>
                <th>Stock mínimo</th>
                <th>Stock máximo</th>
                <th>Cantidad a pedir</th>
                <th>Precio</th>
            </tr>
        </thead>
        <tbody>
            @forelse($ordenes as $orden)
                <tr>
                    <td>{{ $orden->nombre }}</td>
                    <td>{{ $orden->codigo }}</td>
                    <td>
                        @if($orden->producto)
                            <span class="badge {{ ($orden->producto->cantidad <= $orden->producto->minimo) ? 'bg-danger' : 'bg-primary' }}">
                                {{ $orden->producto->cantidad }}
                            </span>
                        @else
                            <span class="badge bg-secondary">Sin producto</span>
                        @endif
                    </td>
                    <td>{{ $orden->minimo }}</td>
                    <td>{{ $orden->maximo }}</td>
                    <td>
                        @if($orden->producto)
                            @php
                                $cantidad_a_pedir = max(0, $orden->maximo - $orden->producto->cantidad);
                            @endphp
                            {{ $cantidad_a_pedir }}
                        @else
                            N/A
                        @endif
                    </td>
                    <td>${{ number_format($orden->precio, 2) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="7" class="no-ordenes">No hay órdenes generadas.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
    <p class="footer">
        Generado el {{ now()->format('d/m/Y H:i') }}
    </p>
</body>
</html>