<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>@yield('title', 'Inventario')</title>
    <link rel="icon" type="image/png" href="{{ asset('logo.png') }}">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    {{-- Bootstrap Icons --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <style>
        .navbar .btn .bi {
            font-size: 1.15rem;
            vertical-align: -0.125em;
        }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-light bg-light mb-4">
    <div class="container">
        <a class="navbar-brand d-flex align-items-center" href="{{ route('productos.index') }}">
            <img src="{{ asset('logo.png') }}" alt="Logo" style="height: 32px; width: 32px; margin-right:8px;">
            Inventario
        </a>
        <div class="d-flex align-items-center">
            @if(Auth::check())
                <a href="{{ route('productos.index') }}" class="btn btn-outline-secondary me-2">
                    <i class="bi bi-box-seam me-1"></i>
                    Inventario
                </a>
                @if(Auth::user()->role === 'administrador')
                    <a href="{{ route('ordenes.index') }}" class="btn btn-outline-warning me-2">
                        <i class="bi bi-truck me-1"></i>
                        Órdenes
                    </a>
                @endif
                <a href="{{ route('ventas.index') }}" class="btn btn-outline-primary me-2">
                    <i class="bi bi-receipt me-1"></i>
                    Historial de ventas
                </a>

                {{-- Ícono de carrito con badge --}}
                <a href="{{ route('carrito.index') }}" class="btn btn-outline-success position-relative me-2">
                    <i class="bi bi-cart me-1"></i>
                    Carrito
                    @php
                        $carritoCantidad = \App\Models\Carrito::where('user_id', auth()->id())->sum('cantidad');
                    @endphp
                    @if($carritoCantidad > 0)
                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                            {{ $carritoCantidad }}
                        </span>
                    @endif
                </a>

                <form action="{{ route('logout') }}" method="POST" style="display:inline;">
                    @csrf
                    <button type="submit" class="btn btn-outline-danger">
                        <i class="bi bi-box-arrow-right me-1"></i>
                        Cerrar sesión
                    </button>
                </form>
            @endif
        </div>
    </div>
</nav>
<div class="container">
    @yield('content')
</div>
</body>
</html>