@extends('layouts.app')

@section('title', 'Mi Carrito')

@section('content')
    <h1>Mi Carrito</h1>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    @if($carrito->isEmpty())
        <div class="alert alert-info">Tu carrito está vacío.</div>
    @else
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Producto</th>
                    <th>Precio</th>
                    <th>Cantidad</th>
                    <th>Subtotal</th>
                    <th>Descuento</th>
                    <th>Total con Descuento</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                @php $total = 0; @endphp
                @foreach($carrito as $item)
                    @php 
                        $subtotal = $item->producto->precio * $item->cantidad; 
                        $total += $subtotal; 
                    @endphp
                    <tr>
                        <td>{{ $item->producto->nombre }}</td>
                        <td>${{ number_format($item->producto->precio, 2) }}</td>
                        <td>
                            <form action="{{ route('carrito.update', $item->id) }}" method="POST" class="d-flex align-items-center">
                                @csrf
                                @method('PATCH')
                                <input type="number" name="cantidad" value="{{ $item->cantidad }}" 
                                        min="1" max="{{ $item->producto->cantidad }}" 
                                        class="form-control form-control-sm" style="width: 70px;">
                                <button type="submit" class="btn btn-success btn-sm ms-2">Actualizar</button>
                            </form>
                        </td>
                        <td>${{ number_format($subtotal, 2) }}</td>
                        <td>
                            <div class="input-group mb-2">
                                <input type="number" name="descuento_producto[{{ $item->producto->id }}]" 
                                        class="form-control form-control-sm" placeholder="0" min="0"
                                        value="{{ old("descuento_producto.{$item->producto->id}", 0) }}" form="procesar-form">
                                <select name="tipo_descuento_producto[{{ $item->producto->id }}]" 
                                         class="form-select form-select-sm" form="procesar-form">
                                    <option value="fijo" {{ old("tipo_descuento_producto.{$item->producto->id}", 'fijo') == 'fijo' ? 'selected' : '' }}>$</option>
                                    <option value="porcentaje" {{ old("tipo_descuento_producto.{$item->producto->id}") == 'porcentaje' ? 'selected' : '' }}>%</option>
                                </select>
                            </div>
                        </td>
                        <td>${{ number_format($subtotal, 2) }}</td>
                        <td>
                            <form action="{{ route('carrito.destroy', $item->id) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-danger btn-sm" onclick="return confirm('¿Eliminar este producto del carrito?')">Eliminar</button>
                            </form>
                        </td>
                    </tr>
                @endforeach

                <tr>
                    <td colspan="3" class="text-end align-middle"><strong>Total:</strong></td>
                    <td class="align-middle"><strong>${{ number_format($total, 2) }}</strong></td>
                    <td class="text-end align-middle"><strong>Descuento general:</strong></td>
                    <td colspan="2">
                        <form action="{{ route('ventas.confirmar') }}" method="POST" id="procesar-form">
                            @csrf
                            <div class="input-group mb-2">
                                <input type="number" name="descuento_general" id="descuento_general" 
                                        class="form-control form-control-sm" placeholder="0" min="0"
                                        value="{{ old('descuento_general', 0) }}">
                                <select name="tipo_descuento_general" id="tipo_descuento_general" 
                                         class="form-select form-select-sm">
                                    <option value="fijo" {{ old('tipo_descuento_general', 'fijo') == 'fijo' ? 'selected' : '' }}>$</option>
                                    <option value="porcentaje" {{ old('tipo_descuento_general') == 'porcentaje' ? 'selected' : '' }}>%</option>
                                </select>
                            </div>
                    </td>
                </tr>

                <tr>
                    <td colspan="3" class="text-end align-middle"><strong>Método de Pago:</strong></td>
                    <td class="align-middle">
                        <select name="metodo_pago" id="metodo_pago" class="form-select form-select-sm" required form="procesar-form">
                            <option value="" disabled selected>Seleccione una opción</option>
                            <option value="Visa" {{ old('metodo_pago') == 'Visa' ? 'selected' : '' }}>Visa</option>
                            <option value="Zelle" {{ old('metodo_pago') == 'Zelle' ? 'selected' : '' }}>Zelle</option>
                            <option value="Cash" {{ old('metodo_pago') == 'Cash' ? 'selected' : '' }}>Cash</option>
                        </select>
                    </td>
                    <td class="text-end align-middle"><strong>Paga con:</strong></td>
                    <td class="align-middle" colspan="2">
                        <input type="number" name="paga_con" id="paga_con" class="form-control form-control-sm" placeholder="0.00" min="0" step="0.01" form="procesar-form" disabled>
                    </td>
                </tr>

                <tr>
                    <td colspan="5"></td>
                    <td colspan="2">
                        <button type="submit" class="btn btn-primary btn-sm w-100" form="procesar-form">Procesar Venta</button>
                        </form>
                    </td>
                </tr>
            </tbody>
        </table>
    @endif

    @if(!$carrito->isEmpty())
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const metodoPago = document.getElementById('metodo_pago');
            const pagaCon = document.getElementById('paga_con');
            const procesarForm = document.getElementById('procesar-form');
            const totalVenta = {{ number_format($total, 2, '.', '') }}; // Obtenemos el total de Laravel

            function togglePagaCon() {
                if (metodoPago.value === 'Cash') {
                    pagaCon.removeAttribute('disabled');
                    pagaCon.setAttribute('required', 'required');
                    pagaCon.focus();
                } else {
                    pagaCon.value = '';
                    pagaCon.removeAttribute('required');
                    pagaCon.setAttribute('disabled', 'disabled');
                }
            }
            
            function validarVentaCash(event) {
                if (metodoPago.value === 'Cash') {
                    const montoPagado = parseFloat(pagaCon.value);
                    if (montoPagado < totalVenta) {
                        event.preventDefault(); // Detenemos el envío del formulario
                        alert('Error: El monto pagado no puede ser menor al total de la venta.');
                        pagaCon.focus();
                    }
                }
            }

            // Inicializamos estado al cargar la página
            togglePagaCon();

            // Escuchamos cambios en el método de pago
            metodoPago.addEventListener('change', togglePagaCon);
            
            // Agregamos el listener para la validación al enviar el formulario
            procesarForm.addEventListener('submit', validarVentaCash);
        });
    </script>
    @endif
@endsection