<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run()
    {
        // Usuario administrador
        User::updateOrCreate(
            ['email' => 'admin@demo.com'],
            [
                'name' => 'Administrador',
                'email' => 'admin@demo.com',
                'password' => Hash::make('administrador'),
                'role' => 'administrador',
            ]
        );

        // Usuario vendedor
        User::updateOrCreate(
            ['email' => 'vendedor@demo.com'],
            [
                'name' => 'Vendedor',
                'email' => 'vendedor@demo.com',
                'password' => Hash::make('vendedor'),
                'role' => 'vendedor',
            ]
        );
    }
}