<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RemovePrecioUnitarioFromVentasTable extends Migration
{
    public function up(): void
    {
        Schema::table('ventas', function (Blueprint $table) {
            // Solo si existe la foreign key
            if (Schema::hasColumn('ventas', 'precio_unitario')) {
                $table->dropColumn('precio_unitario');
            }
        });
    }

    public function down(): void
    {
        Schema::table('ventas', function (Blueprint $table) {
            $table->decimal('precio_unitario', 12, 2)->nullable();
        });
    }
}