<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDetalleVentasTable extends Migration
{
    public function up()
    {
        Schema::create('detalle_ventas', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('venta_id');
            $table->unsignedBigInteger('producto_id')->nullable(); // Permitir nulos para SET NULL
            $table->integer('cantidad');
            $table->decimal('precio', 10, 2);
            $table->decimal('subtotal', 12, 2);
            $table->timestamps();

            $table->foreign('venta_id')
                  ->references('id')->on('ventas')
                  ->onDelete('cascade');

            $table->foreign('producto_id')
                  ->references('id')->on('productos')
                  ->onDelete('set null'); // Si se borra el producto, se pone NULL
        });
    }

    public function down()
    {
        Schema::dropIfExists('detalle_ventas');
    }
}