<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Venta extends Model
{
    use HasFactory;

    // Si tu tabla se llama 'ventas', no necesitas $table. Si tiene otro nombre, descomenta la siguiente línea:
    // protected $table = 'ventas';

    protected $fillable = [
        'user_id',
        'fecha',
        'total',
    ];

    // Relación con usuario
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Relación con los detalles de venta (productos vendidos en esta venta)
    public function detalles()
    {
        return $this->hasMany(DetalleVenta::class);
    }
}