<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Producto extends Model
{
    use HasFactory;

    protected $fillable = [
        'nombre',
        'marca',     // Nuevo campo agregado
        'codigo',
        'cantidad',
        'minimo',    // Stock mínimo
        'maximo',    // Stock máximo
        'precio',
        'costo',
        'descripcion',
        'imagen',
    ];

    /**
     * Relación: Un producto puede tener muchas órdenes asociadas.
     */
    public function ordenes()
    {
        return $this->hasMany(Orden::class);
    }

    /**
     * Accesor para obtener el stock mínimo con nombre consistente
     */
    public function getStockMinimoAttribute()
    {
        return $this->minimo;
    }

    /**
     * Accesor para obtener el stock máximo con nombre consistente
     */
    public function getStockMaximoAttribute()
    {
        return $this->maximo;
    }

    /**
     * Verifica si el producto está bajo en stock
     */
    public function estaBajoEnStock()
    {
        if (is_null($this->minimo)) {
            return false;
        }
        
        return $this->cantidad <= $this->minimo;
    }

    /**
     * Verifica si el producto está sobre stock
     */
    public function estaSobreStock()
    {
        if (is_null($this->maximo)) {
            return false;
        }
        
        return $this->cantidad >= $this->maximo;
    }
}