<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Orden extends Model
{
    use HasFactory;

    // Especifica el nombre correcto de la tabla
    protected $table = 'ordenes';

    protected $fillable = [
        'producto_id',
        'nombre',
        'precio',
        'descripcion',
        'codigo',
        'minimo',
        'maximo',
        'imagen',
    ];

    /**
     * Relación: Una orden pertenece a un producto.
     */
    public function producto()
    {
        return $this->belongsTo(Producto::class);
    }
}