<?php

namespace App\Exports;

use App\Models\Venta;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Http\Request;

class VentasExport implements FromView
{
    protected $busqueda;
    protected $fecha_inicio;
    protected $fecha_fin;

    public function __construct($busqueda = null, $fecha_inicio = null, $fecha_fin = null)
    {
        $this->busqueda = $busqueda;
        $this->fecha_inicio = $fecha_inicio;
        $this->fecha_fin = $fecha_fin;
    }

    public function view(): View
    {
        $query = Venta::with(['user', 'detalles.producto'])->orderBy('created_at', 'desc');

        if ($this->busqueda) {
            $busqueda = $this->busqueda;
            $query->where(function ($q) use ($busqueda) {
                $q->where('id', $busqueda)
                  ->orWhereHas('user', function ($q2) use ($busqueda) {
                      $q2->where('name', 'like', '%' . $busqueda . '%');
                  });
            });
        }

        if ($this->fecha_inicio) {
            $query->whereDate('created_at', '>=', $this->fecha_inicio);
        }

        if ($this->fecha_fin) {
            $query->whereDate('created_at', '<=', $this->fecha_fin);
        }

        $ventas = $query->get();

        return view('ventas.excel', [
            'ventas' => $ventas,
            'fecha_inicio' => $this->fecha_inicio,
            'fecha_fin' => $this->fecha_fin,
        ]);
    }
}