<?php

namespace App\Exports;

use App\Models\Producto;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithMapping;

class ProductosExport implements FromCollection, WithHeadings, ShouldAutoSize, WithMapping
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        // Obtiene todos los productos de la base de datos
        return Producto::all();
    }

    /**
     * Define los encabezados para el archivo de Excel.
     *
     * @return array
     */
    public function headings(): array
    {
        return [
            'ID',
            'Nombre',
            'Marca',
            'Cantidad',
            'Precio',
            'Descripción',
            'Código',
            'Stock Mínimo',
            'Stock Máximo',
        ];
    }

    /**
     * Mapea cada fila de la colección a una fila para el archivo de Excel.
     *
     * @param mixed $producto
     * @return array
     */
    public function map($producto): array
    {
        return [
            $producto->id,
            $producto->nombre,
            $producto->marca,
            $producto->cantidad,
            $producto->precio,
            $producto->descripcion,
            $producto->codigo,
            $producto->minimo,
            $producto->maximo,
        ];
    }
}
