@extends('layouts.app')

@section('title', 'Historial de Ventas')

@section('content')
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        h1, h2 { margin-bottom: 0.5em; }
        .venta-header { background: #f0f4ff; padding: 6px 0; margin-top: 20px; border-top: 2px solid #b0c4de; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 16px; }
        th, td { border: 1px solid #aaa; padding: 5px 4px; }
        th { background: #e9ecef; }
        .detalle-table th, .detalle-table td { font-size: 11px; }
        .no-ventas { margin-top: 30px; font-size: 16px; color: #888; }
    </style>
    <h1>Historial de Ventas</h1>
    @if($fecha_inicio || $fecha_fin)
        <p>
            <strong>Filtros:</strong>
            @if($fecha_inicio) Desde: {{ $fecha_inicio }} @endif
            @if($fecha_fin) Hasta: {{ $fecha_fin }} @endif
        </p>
    @endif

    @forelse($ventas as $venta)
        <div class="venta-header">
            <strong>ID Venta:</strong> {{ $venta->id }} &nbsp;&nbsp;
            <strong>Vendedor:</strong> {{ $venta->user->name ?? '-' }} &nbsp;&nbsp;
            <strong>Fecha:</strong> {{ $venta->created_at->format('d/m/Y H:i') }} &nbsp;&nbsp;
            <strong>Total:</strong> ${{ number_format($venta->total, 2) }}
        </div>
        <table class="detalle-table">
            <thead>
                <tr>
                    <th>Producto</th>
                    <th>Cantidad</th>
                    <th>Precio Unitario</th>
                    <th>Subtotal</th>
                    <th>Descuento</th>
                    <th>Total Línea</th>
                </tr>
            </thead>
            <tbody>
                @foreach($venta->detalles as $detalle)
                    <tr>
                        <td>{{ $detalle->producto->nombre ?? 'Producto eliminado' }}</td>
                        <td>{{ $detalle->cantidad }}</td>
                        <td>${{ number_format($detalle->precio, 2) }}</td>
                        <td>${{ number_format($detalle->subtotal, 2) }}</td>
                        <td>
                            @if($detalle->descuento)
                                ${{ number_format($detalle->descuento, 2) }}
                            @else
                                0
                            @endif
                        </td>
                        <td>
                            @php
                                $totalLinea = $detalle->subtotal - ($detalle->descuento ?? 0);
                            @endphp
                            ${{ number_format($totalLinea, 2) }}
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        @if($venta->descuentos)
            @php
                $desc = json_decode($venta->descuentos, true);
            @endphp
            <p>
                <strong>Descuento general:</strong>
                @if(isset($desc['general']))
                    {{ $desc['general']['monto'] }} ({{ $desc['general']['tipo'] }})
                @else
                    0
                @endif
            </p>
        @endif
    @empty
        <div class="no-ventas">No hay ventas registradas.</div>
    @endforelse

    <p style="margin-top:40px; font-size:11px;">
        Generado el {{ now()->format('d/m/Y H:i') }}
    </p>
@endsection