@extends('layouts.app')

@section('title', 'Detalle de Producto')

@section('content')
    <h1>Detalle de Producto</h1>
    <div class="row">
        <div class="col-md-4">
            @if($producto->imagen)
                <img src="{{ asset('storage/'.$producto->imagen) }}" alt="Imagen" class="img-fluid rounded mb-2">
            @else
                <span class="text-muted">Sin imagen</span>
            @endif
        </div>
        <div class="col-md-8">
            <ul class="list-group">
                <li class="list-group-item"><b>ID:</b> {{ $producto->id }}</li>
                <li class="list-group-item"><b>Código:</b>
                    @if($producto->codigo)
                        {{ $producto->codigo }}
                    @else
                        <span class="text-muted">-</span>
                    @endif
                </li>
                <li class="list-group-item"><b>Nombre:</b> {{ $producto->nombre }}</li>
                <!-- Campo marca -->
                <li class="list-group-item"><b>Marca:</b>
                    @if($producto->marca)
                        {{ $producto->marca }}
                    @else
                        <span class="text-muted">-</span>
                    @endif
                </li>
                <li class="list-group-item"><b>Cantidad:</b> {{ $producto->cantidad }}</li>
                <li class="list-group-item"><b>Stock mínimo:</b>
                    @if(isset($producto->stock_minimo))
                        {{ $producto->stock_minimo }}
                    @elseif(isset($producto->minimo))
                        {{ $producto->minimo }}
                    @else
                        <span class="text-muted">-</span>
                    @endif
                </li>
                <li class="list-group-item"><b>Stock máximo:</b>
                    @if(isset($producto->stock_maximo))
                        {{ $producto->stock_maximo }}
                    @elseif(isset($producto->maximo))
                        {{ $producto->maximo }}
                    @else
                        <span class="text-muted">-</span>
                    @endif
                </li>
                <li class="list-group-item"><b>Precio:</b> ${{ number_format($producto->precio, 2) }}</li>
                @if(Auth::user() && Auth::user()->role === 'administrador')
                    <li class="list-group-item"><b>Costo:</b>
                        @if($producto->costo !== null)
                            ${{ number_format($producto->costo, 2) }}
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    </li>
                @endif
                <li class="list-group-item"><b>Descripción:</b> {{ $producto->descripcion }}</li>
            </ul>
        </div>
    </div>
    <a href="{{ route('productos.index') }}" class="btn btn-secondary mt-3">Volver</a>
@endsection