@extends('layouts.app')

@section('title', 'Lista de Productos')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Lista de Productos</h1>
        <form class="d-flex" method="GET" action="{{ route('productos.index') }}">
            <input type="text" name="search" class="form-control me-2" placeholder="Buscar producto..." value="{{ request('search') }}">
            <button class="btn btn-outline-success" type="submit">Buscar</button>
        </form>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    @if(Auth::user() && Auth::user()->role === 'administrador')
        <a href="{{ route('productos.create') }}" class="btn btn-primary mb-3">Crear Producto</a>
    @endif

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Imagen</th>
                <th>ID</th>
                <th>Nombre</th>
                <th>Marca</th>
                <th>Código</th>
                <th>Cantidad</th>
                <th>Stock mínimo</th>
                <th>Stock máximo</th>
                <th>Precio</th>
                @if(Auth::user() && Auth::user()->role === 'administrador')
                    <th>Costo</th>
                @endif
                <th>Descripción</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @forelse($productos as $producto)
                <tr>
                    <td>
                        @if($producto->imagen)
                            <img src="{{ asset('storage/'.$producto->imagen) }}" alt="Imagen" style="max-width:80px;max-height:80px;">
                        @else
                            <span class="text-muted">Sin imagen</span>
                        @endif
                    </td>
                    <td>{{ $producto->id }}</td>
                    <td>{{ $producto->nombre }}</td>
                    <td>
                        @if($producto->marca)
                            {{ $producto->marca }}
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    </td>
                    <td>
                        @if($producto->codigo)
                            {{ $producto->codigo }}
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    </td>
                    <td>{{ $producto->cantidad }}</td>
                    <td>
                        @if(isset($producto->stock_minimo))
                            {{ $producto->stock_minimo }}
                        @elseif(isset($producto->minimo))
                            {{ $producto->minimo }}
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    </td>
                    <td>
                        @if(isset($producto->stock_maximo))
                            {{ $producto->stock_maximo }}
                        @elseif(isset($producto->maximo))
                            {{ $producto->maximo }}
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    </td>
                    <td>${{ number_format($producto->precio, 2) }}</td>
                    @if(Auth::user() && Auth::user()->role === 'administrador')
                        <td>
                            @if($producto->costo !== null)
                                ${{ number_format($producto->costo, 2) }}
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                    @endif
                    <td>{{ \Illuminate\Support\Str::limit($producto->descripcion, 65) }}</td>
                    <td>
                        <div class="d-flex flex-wrap gap-2">
                            <a href="{{ route('productos.show', $producto) }}" class="btn btn-info btn-sm">Ver</a>
                            @if(Auth::user() && Auth::user()->role === 'administrador')
                                <a href="{{ route('productos.edit', $producto) }}" class="btn btn-warning btn-sm">Editar</a>
                                <form action="{{ route('productos.destroy', $producto) }}" method="POST" style="display:inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button class="btn btn-danger btn-sm" onclick="return confirm('¿Estás seguro de eliminar este producto?')">Eliminar</button>
                                </form>
                            @endif

                            {{-- BOTÓN AGREGAR AL CARRITO --}}
                            @if($producto->cantidad > 0)
                                <form action="{{ route('carrito.store') }}" method="POST" style="display:inline-flex;align-items:center;">
                                    @csrf
                                    <input type="hidden" name="producto_id" value="{{ $producto->id }}">
                                    <input type="number" name="cantidad" value="1" min="1" max="{{ $producto->cantidad }}" style="width:60px;margin-right:5px;" required>
                                    <button type="submit" class="btn btn-primary btn-sm">Agregar al carrito</button>
                                </form>
                            @else
                                <span class="text-muted">Sin stock</span>
                            @endif
                        </div>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="@if(Auth::user() && Auth::user()->role === 'administrador')12 @else 11 @endif">No hay productos registrados.</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div>
        {{ $productos->withQueryString()->links() }}
    </div>
@endsection