<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Carrito extends Model
{
    use HasFactory;

    protected $table = 'carritos';

    protected $fillable = [
        'user_id',
        'producto_id',
        'cantidad',
    ];

    /**
     * Relación: El producto de este ítem de carrito.
     */
    public function producto()
    {
        return $this->belongsTo(Producto::class);
    }

    /**
     * Relación: El usuario dueño de este carrito.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}