

<?php $__env->startSection('title', $product->name . ' - Herbal Solutions'); ?>
<?php $__env->startSection('body-class', 'product-details-page'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Page Title -->
    <div class="page-title dark-background">
        <div class="container d-lg-flex justify-content-between align-items-center">
            <h1 class="mb-2 mb-lg-0"><?php echo e($product->name); ?></h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="<?php echo e(url('/')); ?>" class="<?php echo e(request()->is('/') ? 'active' : ''); ?>"><?php echo e(__('messages.home')); ?></a></li>
                    <li><a href="<?php echo e(route('store')); ?>" class="<?php echo e(request()->routeIs('store') ? 'active' : ''); ?>"><?php echo e(__('messages.store')); ?></a></li>
                    <li class="current"><?php echo e($product->name); ?></li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Product Details Section -->
    <section id="product-details" class="section">
        <div class="container">
            <div class="row gy-4" data-aos="fade-up" data-aos-delay="200">
                <!-- Product Image -->
                <div class="col-lg-6">
                    <div class="card image-card">
                        <a href="<?php echo e($product->image ? asset('storage/' . $product->image) : asset('assets/img/default-product.png')); ?>" class="glightbox">
                            <img src="<?php echo e($product->image ? asset('storage/' . $product->image) : asset('assets/img/default-product.png')); ?>" class="card-img-top" alt="<?php echo e($product->name); ?>">
                        </a>
                    </div>
                </div>
                <!-- Product Details -->
                <div class="col-lg-6">
                    <div class="card h-100">
                        <div class="card-body d-flex flex-column justify-content-between">
                            <div>
                                <h2 class="card-title"><?php echo e($product->name); ?></h2>
                                <div class="card-text category-price">
                                    <p class="mb-1">Categoría: <?php echo e(__('messages.' . $product->category)); ?></p>
                                    <p class="mb-1">Precio Regular: <s class="text-muted">$<?php echo e(number_format($product->price, 2)); ?></s></p>
                                    <p class="mb-1">Precio Actual: 
                                        <span class="<?php echo e($product->is_discounted ? 'discounted-price' : ''); ?>">
                                            $<?php echo e(number_format($product->is_discounted && $product->discount_price ? $product->discount_price : $product->price, 2)); ?>

                                        </span>
                                    </p>
                                </div>
                                <hr class="my-3">
                                <p class="card-text description">
                                    <?php if(isset($product->description) && !empty($product->description)): ?>
                                        <?php echo e($product->description); ?>

                                    <?php else: ?>
                                        <?php echo e(__('messages.product_description_placeholder', ['category' => __('messages.' . $product->category)])); ?>

                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="row g-2">
                                <div class="col-4">
                                    <div class="input-group quantity-box">
                                        <button class="btn btn-outline-secondary" type="button" onclick="this.nextElementSibling.stepDown()">-</button>
                                        <input type="number" class="form-control text-center" value="1" min="1" max="100" data-product-id="<?php echo e($product->id); ?>">
                                        <button class="btn btn-outline-secondary" type="button" onclick="this.previousElementSibling.stepUp()">+</button>
                                    </div>
                                </div>
                                <div class="col-8">
                                    <button class="btn btn-primary add-to-cart w-100" data-product-id="<?php echo e($product->id); ?>"><?php echo e(__('messages.add_to_cart')); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('assets/vendor/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/vendor/aos/aos.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/vendor/glightbox/css/glightbox.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/main.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/custom.css')); ?>" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@500;700&display=swap" rel="stylesheet">
    <style>
        .page-title h1 {
            font-family: 'Montserrat', sans-serif;
            font-weight: 700;
            font-size: 2.5rem;
            color: #fff;
        }
        .card {
            border-radius: 10px;
            background-color: #fff;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            border: 1px solid #e0e0e0;
            transition: transform 0.2s ease;
        }
        .card:hover {
            transform: translateY(-2px);
        }
        .image-card {
            overflow: visible !important;
            max-height: none !important;
        }
        body.product-details-page div.card.image-card img.card-img-top {
            border-top-left-radius: 10px !important;
            border-top-right-radius: 10px !important;
            object-fit: contain !important;
            max-height: 450px !important;
            width: 100% !important;
            height: auto !important;
            display: block !important;
            transition: transform 0.3s ease !important;
        }
        body.product-details-page div.card.image-card:hover img.card-img-top {
            transform: scale(1.02) !important;
        }
        .card-body {
            padding: 25px;
        }
        .card-title {
            font-family: 'Montserrat', sans-serif;
            font-size: 2.2rem;
            font-weight: 700;
            margin-bottom: 0.75rem;
            color: #333;
        }
        .category-price {
            font-size: 1.2rem;
            color: #6c757d;
            margin-bottom: 0;
        }
        .category-price s.text-muted {
            color: #6c757d !important;
            margin-right: 8px;
        }
        .category-price .discounted-price {
            color: #dc3545;
            font-weight: 700;
        }
        .category-price p {
            margin-bottom: 0.25rem;
        }
        .description {
            font-size: 1rem;
            color: #555;
            line-height: 1.6;
        }
        .btn-primary {
            background-color: #28a745;
            border-color: #28a745;
            height: 38px;
            line-height: 1.5;
            font-size: 0.85rem;
            padding: 0 10px;
            text-align: center;
            transition: all 0.2s ease;
        }
        .btn-primary:hover {
            background-color: #218838;
            border-color: #1e7e34;
            transform: translateY(-1px);
        }
        .quantity-box {
            width: 100%;
            height: 38px;
        }
        .quantity-box .btn {
            width: 30%;
            height: 38px;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 0.85rem;
            transition: all 0.2s ease;
        }
        .quantity-box .form-control {
            width: 40%;
            height: 38px;
            padding: 0;
            font-size: 0.85rem;
            text-align: center;
        }
        .quantity-box .btn:hover {
            background-color: #f8f9fa;
        }
        @media (max-width: 576px) {
            .page-title h1 {
                font-size: 1.8rem;
            }
            body.product-details-page div.card.image-card img.card-img-top {
                max-height: 300px !important;
                height: auto !important;
            }
            .card-title {
                font-size: 1.6rem;
            }
            .category-price {
                font-size: 1rem;
            }
            .category-price s.text-muted {
                margin-right: 6px;
            }
            .category-price .discounted-price {
                font-size: 1rem;
            }
            .description {
                font-size: 0.9rem;
            }
            .btn-primary {
                height: 34px;
                font-size: 0.8rem;
                padding: 0 8px;
            }
            .quantity-box {
                width: 100%;
                height: 34px;
            }
            .quantity-box .btn {
                width: 30%;
                height: 34px;
                font-size: 0.8rem;
            }
            .quantity-box .form-control {
                width: 40%;
                height: 34px;
                font-size: 0.8rem;
            }
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>" async></script>
    <script src="<?php echo e(asset('assets/vendor/aos/aos.js')); ?>" async></script>
    <script src="<?php echo e(asset('assets/vendor/glightbox/js/glightbox.min.js')); ?>" async></script>
    <script>
        console.log('Product Details: Script cargado - Versión 2025-04-25');

        document.addEventListener('click', (e) => {
            const button = e.target.closest('.add-to-cart');
            if (!button) return;

            e.preventDefault();
            console.log('Product Details: Clic en add-to-cart');

            const productId = button.getAttribute('data-product-id')?.trim();
            const quantityInput = document.querySelector(`input[data-product-id="${productId}"]`);
            const quantity = quantityInput ? parseInt(quantityInput.value) : 1;

            console.log(`Product Details: productId: "${productId}", quantity: ${quantity}`);

            const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
            if (!csrfToken) {
                console.error('Product Details: CSRF token no encontrado');
                alert('Error: Token CSRF no encontrado. Por favor, recarga la página.');
                return;
            }

            if (!productId || isNaN(parseInt(productId)) || isNaN(quantity) || quantity < 1) {
                console.error('Product Details: Datos inválidos', { productId, quantity });
                alert('Error: Datos de producto o cantidad inválidos');
                return;
            }

            button.disabled = true;
            button.textContent = 'Añadiendo...';

            fetch('<?php echo e(route('cart.add')); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json'
                },
                body: JSON.stringify({ product_id: parseInt(productId), quantity })
            })
            .then(response => {
                console.log(`Product Details: Respuesta /cart/add: ${response.status}`);
                if (!response.ok) {
                    return response.json().then(err => {
                        throw new Error(err.message || `Error HTTP: ${response.status}`);
                    });
                }
                return response.json();
            })
            .then(data => {
                console.log('Product Details: Respuesta JSON:', JSON.stringify(data, null, 2));
                if (data.success && data.cart !== undefined) {
                    console.log('Product Details: Carrito actualizado:', data.cart);
                    const cartCount = document.getElementById('cart-count');
                    if (cartCount) {
                        const totalItems = Object.values(data.cart).reduce((sum, item) => sum + item.quantity, 0);
                        console.log(`Product Details: Actualizando #cart-count a: ${totalItems}`);
                        cartCount.textContent = totalItems;
                    }
                    alert('Producto añadido al carrito');
                } else {
                    console.error('Product Details: Error en respuesta:', data.message || 'Respuesta inválida');
                    alert('Error: ' + (data.message || 'No se pudo añadir el producto'));
                }
            })
            .catch(error => {
                console.error('Product Details: Error al añadir:', error.message);
                alert('Error al añadir el producto: ' + error.message);
            })
            .finally(() => {
                button.disabled = false;
                button.textContent = '<?php echo e(__('messages.add_to_cart')); ?>';
                console.log('Product Details: Botón restaurado');
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\herbalsolutions\resources\views/store/show.blade.php ENDPATH**/ ?>