

<?php $__env->startSection('title', 'Checkout - Herbal Solutions'); ?>
<?php $__env->startSection('body-class', 'checkout-page'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Page Title -->
    <div class="page-title dark-background">
        <div class="container d-lg-flex justify-content-between align-items-center">
            <h1 class="mb-2 mb-lg-0"><?php echo e(__('messages.checkout')); ?></h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="<?php echo e(url('/')); ?>" class="<?php echo e(request()->is('/') ? 'active' : ''); ?>"><?php echo e(__('messages.home')); ?></a></li>
                    <li class="current"><?php echo e(__('messages.checkout')); ?></li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Checkout Section -->
    <section class="section">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h4><?php echo e(__('messages.cart_summary')); ?></h4>
                    <table class="table">
                        <thead>
                            <tr>
                                <th><?php echo e(__('messages.product')); ?></th>
                                <th><?php echo e(__('messages.quantity')); ?></th>
                                <th><?php echo e(__('messages.price')); ?></th>
                                <th><?php echo e(__('messages.total')); ?></th>
                                <th><?php echo e(__('messages.actions')); ?></th>
                            </tr>
                        </thead>
                        <tbody id="cart-table">
                            <?php $__empty_1 = true; $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr data-product-id="<?php echo e($id); ?>">
                                    <td><?php echo e($item['name']); ?></td>
                                    <td class="quantity"><?php echo e($item['quantity']); ?></td>
                                    <td class="price">$<?php echo e(number_format($item['price'], 2)); ?></td>
                                    <td class="total">$<?php echo e(number_format($item['price'] * $item['quantity'], 2)); ?></td>
                                    <td>
                                        <button class="btn btn-danger btn-sm checkout-remove-from-cart" data-product-id="<?php echo e($id); ?>"><?php echo e(__('messages.remove')); ?></button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center"><?php echo e(__('messages.cart_empty')); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                    <p class="fw-bold">Total: <span id="cart-total">$<?php echo e(number_format($total, 2)); ?></span></p>
                </div>
                <div class="col-md-6">
                    <h4><?php echo e(__('messages.payment')); ?></h4>
                    <?php if(session('error')): ?>
                        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
                    <?php endif; ?>
                    <?php if(session('success')): ?>
                        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                    <?php endif; ?>
                    <div class="form-container">
                        <form id="payment-form" class="payment-form" method="POST" action="<?php echo e(route('payment')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="input-container mb-3">
                                <label for="recipient_name" class="form-label"><?php echo e(__('messages.nombre_recibe')); ?></label>
                                <input type="text" class="form-control <?php $__errorArgs = ['recipient_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="recipient_name" name="recipient_name" placeholder="<?php echo e(__('messages.nombre_completo')); ?>" value="<?php echo e(old('recipient_name')); ?>" required>
                                <?php $__errorArgs = ['recipient_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="input-container mb-3">
                                <label for="shipping_address" class="form-label"><?php echo e(__('messages.direccion_envio')); ?></label>
                                <input type="text" class="form-control <?php $__errorArgs = ['shipping_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="shipping_address" name="shipping_address" placeholder="<?php echo e(__('messages.direccion_completa')); ?>" value="<?php echo e(old('shipping_address')); ?>" required>
                                <?php $__errorArgs = ['shipping_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="input-container mb-3">
                                <label for="amount" class="form-label"><?php echo e(__('messages.total_amount')); ?></label>
                                <input type="text" class="form-control" id="amount" name="amount" value="<?php echo e(number_format($total, 2)); ?>" readonly>
                            </div>
                            <div class="input-container mb-3">
                                <label for="card_number" class="form-label"><?php echo e(__('messages.card_number')); ?></label>
                                <input type="text" class="form-control" id="card_number" placeholder="1234 5678 9012 3456" required>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <div class="input-container">
                                        <label for="expiry_date" class="form-label"><?php echo e(__('messages.expiry_date')); ?></label>
                                        <input type="text" class="form-control" id="expiry_date" placeholder="MM/YY" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="input-container">
                                        <label for="cvv" class="form-label"><?php echo e(__('messages.cvv')); ?></label>
                                        <input type="text" class="form-control" id="cvv" placeholder="123" required>
                                    </div>
                                </div>
                            </div>
                            <div class="button-container">
                                <div class="button-wrapper">
                                    <button type="submit" class="btn btn-primary"><?php echo e(__('messages.pay_now')); ?></button>
                                    <a href="<?php echo e(route('store')); ?>" class="btn btn-secondary"><?php echo e(__('messages.back_to_store')); ?></a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script src="https://js.authorize.net/v1/Accept.js"></script>
    <script>
        window.LaravelRoutes = {
            cartRemove: "<?php echo e(route('cart.remove')); ?>",
            cartGet: "<?php echo e(route('cart.get')); ?>"
        };

        document.getElementById('expiry_date').addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length > 4) {
                value = value.slice(0, 4);
            }
            if (value.length >= 3) {
                value = value.slice(0, 2) + '/' + value.slice(2);
            }
            e.target.value = value;
        });

        document.getElementById('payment-form').addEventListener('submit', async function(e) {
            e.preventDefault();

            const cardNumber = document.getElementById('card_number').value;
            const expiryDate = document.getElementById('expiry_date').value;
            const cvv = document.getElementById('cvv').value;
            const amount = document.getElementById('amount').value;
            const recipientName = document.getElementById('recipient_name').value;
            const shippingAddress = document.getElementById('shipping_address').value;

            if (!cardNumber || !expiryDate || !cvv || !amount || !recipientName || !shippingAddress) {
                alert('Por favor, completa todos los campos.');
                return;
            }

            const authData = {
                apiLoginID: '<?php echo e(config('services.authorizenet.api_login_id')); ?>',
                clientKey: '<?php echo e(config('services.authorizenet.client_key')); ?>'
            };

            const cardData = {
                cardNumber: cardNumber.replace(/\s/g, ''),
                month: expiryDate.split('/')[0],
                year: expiryDate.split('/')[1],
                cardCode: cvv
            };

            const secureData = {
                authData: authData,
                cardData: cardData
            };

            Accept.dispatchData(secureData, function(response) {
                if (response.messages.resultCode === 'Error') {
                    let errorMsg = response.messages.message.map(msg => `${msg.code}: ${msg.text}`).join('; ');
                    alert('Error al procesar el pago: ' + errorMsg);
                } else {
                    const nonce = response.opaqueData.dataValue;
                    processPayment(nonce, amount, recipientName, shippingAddress);
                }
            });
        });

        async function processPayment(nonce, amount, recipientName, shippingAddress) {
            try {
                const response = await fetch('<?php echo e(route('payment')); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({
                        nonce: nonce,
                        amount: amount,
                        recipient_name: recipientName,
                        shipping_address: shippingAddress
                    })
                });

                const result = await response.json();
                if (result.success) {
                    alert('Pago exitoso. ID de transacción: ' + result.transactionId);
                    window.location.href = '<?php echo e(route('store')); ?>?success=' + encodeURIComponent('<?php echo e(__('messages.payment_success')); ?>');
                } else {
                    alert('Error en el pago: ' + result.error);
                }
            } catch (error) {
                alert('Error en la comunicación con el servidor: ' + error.message);
            }
        }

        window.updateCheckoutForm = function(cart) {
            try {
                const cartTable = document.getElementById('cart-table');
                const cartTotal = document.getElementById('cart-total');
                const amountInput = document.getElementById('amount');

                if (!cartTable || !cartTotal || !amountInput) return;

                cartTable.innerHTML = '';
                if (!cart || typeof cart !== 'object' || Object.keys(cart).length === 0) {
                    cartTable.innerHTML = `
                        <tr>
                            <td colspan="5" class="text-center"><?php echo e(__('messages.cart_empty')); ?></td>
                        </tr>
                    `;
                    cartTotal.textContent = '$0.00';
                    amountInput.value = '0.00';
                    amountInput.setAttribute('value', '0.00');
                    setTimeout(() => {
                        window.location.href = '<?php echo e(route('store')); ?>?error=<?php echo e(__('messages.cart_empty')); ?>';
                    }, 1000);
                    return;
                }

                Object.entries(cart).forEach(([id, item]) => {
                    const price = parseFloat(item.price) || 0;
                    const quantity = item.quantity || 0;
                    const total = (price * quantity).toFixed(2);
                    const row = `
                        <tr data-product-id="${id}">
                            <td>${item.name}</td>
                            <td class="quantity">${quantity}</td>
                            <td class="price">$${price.toFixed(2)}</td>
                            <td class="total">$${total}</td>
                            <td>
                                <button class="btn btn-danger btn-sm checkout-remove-from-cart" data-product-id="${id}"><?php echo e(__('messages.remove')); ?></button>
                            </td>
                        </tr>
                    `;
                    cartTable.insertAdjacentHTML('beforeend', row);
                });

                const total = Object.values(cart).reduce((sum, item) => {
                    const price = parseFloat(item.price) || 0;
                    const quantity = item.quantity || 0;
                    return sum + (price * quantity);
                }, 0);

                cartTotal.textContent = `$${total.toFixed(2)}`;
                setTimeout(() => {
                    amountInput.value = total.toFixed(2);
                    amountInput.setAttribute('value', total.toFixed(2));
                    amountInput.dispatchEvent(new Event('change'));
                }, 0);

                if (typeof window.updateCart === 'function') {
                    window.updateCart(cart);
                }

                const cartUpdateEvent = new CustomEvent('cartUpdated', { detail: { cart } });
                document.dispatchEvent(cartUpdateEvent);
            } catch (error) {
                alert('Error al actualizar el carrito. Recargando página...');
                setTimeout(() => {
                    window.location.reload();
                }, 1000);
            }
        };

        document.body.addEventListener('click', (e) => {
            const button = e.target.closest('.checkout-remove-from-cart');
            if (!button) return;

            e.preventDefault();
            e.stopPropagation();

            const productId = button.getAttribute('data-product-id')?.trim();
            const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');

            if (!csrfToken) {
                alert('Error: Token CSRF no encontrado. Por favor, recarga la página.');
                return;
            }
            if (!productId || isNaN(parseInt(productId))) {
                alert('Error: ID de producto inválido');
                return;
            }

            button.disabled = true;
            button.textContent = '<?php echo e(__('messages.removing')); ?>';

            fetch(window.LaravelRoutes.cartRemove, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json'
                },
                body: JSON.stringify({ product_id: parseInt(productId) })
            })
            .then(async response => {
                const text = await response.text();
                if (!response.ok) {
                    try {
                        const err = JSON.parse(text);
                        throw new Error(err.message || `Error HTTP: ${response.status}`);
                    } catch {
                        throw new Error(`Error HTTP: ${response.status}`);
                    }
                }
                return JSON.parse(text);
            })
            .then(data => {
                return fetch(window.LaravelRoutes.cartGet, {
                    method: 'GET',
                    headers: {
                        'Accept': 'application/json'
                    }
                });
            })
            .then(async response => {
                const text = await response.text();
                if (!response.ok) {
                    window.location.reload();
                    return;
                }
                try {
                    return JSON.parse(text);
                } catch {
                    window.location.reload();
                    return;
                }
            })
            .then(data => {
                if (data && data.cart !== undefined) {
                    window.updateCheckoutForm(data.cart);
                    const cartCount = document.getElementById('cart-count');
                    if (cartCount) {
                        const totalItems = Object.values(data.cart).reduce((sum, item) => sum + (item.quantity || 0), 0);
                        cartCount.textContent = totalItems;
                    }
                } else {
                    window.location.reload();
                }
            })
            .catch(error => {
                alert('Error al actualizar el carrito: ' + error.message);
            })
            .finally(() => {
                button.disabled = false;
                button.textContent = '<?php echo e(__('messages.remove')); ?>';
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .table {
            border-radius: 10px;
            background-color: #fff;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .btn-primary {
            background-color: #28a745;
            border-color: #28a745;
            width: 150px;
            min-width: 120px;
            padding: 8px 0;
            text-align: center;
        }
        .btn-primary:hover {
            background-color: #218838;
            border-color: #1e7e34;
        }
        .btn-secondary {
            background-color: #03a103;
            border-color: #03a103;
            width: 150px;
            min-width: 120px;
            padding: 8px 0;
            text-align: center;
        }
        .btn-secondary:hover {
            background-color: #028902;
            border-color: #028902;
        }
        .btn-danger {
            background-color: #dc3545;
            border-color: #dc3545;
        }
        .btn-danger:hover {
            background-color: #c82333;
            border-color: #bd2130;
        }
        h4, .fw-bold, .form-label {
            font-family: 'Montserrat', sans-serif;
            font-weight: 700;
        }
        .alert, .form-control {
            border-radius: 10px;
        }
        .form-container {
            width: 100%;
            max-width: 500px;
            margin: 0 auto;
            text-align: center;
        }
        .input-container {
            width: 100%;
            max-width: 500px;
            margin: 0 auto;
        }
        .payment-form {
            width: 100%;
            max-width: 500px;
            margin: 0 auto;
        }
        .form-control {
            width: 100%;
        }
        .button-container {
            width: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
            margin-top: 20px;
        }
        .button-wrapper {
            display: flex;
            justify-content: center;
            gap: 10px;
        }
        @media (max-width: 576px) {
            .table, .form-control {
                font-size: 0.875rem;
            }
            h4 {
                font-size: 1.25rem;
            }
            .btn-primary, .btn-secondary {
                width: 100%;
                min-width: 100px;
            }
            .form-container, .input-container, .payment-form {
                width: 100%;
                max-width: 100%;
            }
            .button-container {
                flex-direction: column;
                align-items: center;
            }
            .button-wrapper {
                flex-direction: column;
                align-items: center;
                width: 100%;
            }
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <!-- Scripts ya cargados en app.blade.php -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\herbalsolutions\resources\views/store/checkout.blade.php ENDPATH**/ ?>