<section id="store" class="portfolio section">
    <div class="container">
        <div class="isotope-layout" data-default-filter="*" data-layout="masonry" data-sort="original-order">
            <div class="container section-title" data-aos="fade-up">
                <h2><?php echo e(__('messages.store')); ?></h2>
                <p><?php echo e(__('messages.explore_products')); ?></p>
            </div>

            <ul class="portfolio-filters isotope-filters" data-aos="fade-up" data-aos-delay="100">
                <li data-filter="*" class="filter-active"><?php echo e(__('messages.all')); ?></li>
                <li data-filter=".filter-cinturita"><?php echo e(__('messages.waistline')); ?></li>
                <li data-filter=".filter-Dietary_Supplement"><?php echo e(__('messages.dietary_supplement')); ?></li>
                <li data-filter=".filter-Digestion_Gut"><?php echo e(__('messages.digestion_stomach')); ?></li>
                <li data-filter=".filter-Digestive_Intestinal"><?php echo e(__('messages.digestive_intestinal')); ?></li>
                <li data-filter=".filter-Teas"><?php echo e(__('messages.teas')); ?></li>
                <li data-filter=".filter-Weight_Management"><?php echo e(__('messages.weight_control')); ?></li>
                <li data-filter=".filter-Cleansing_Detox"><?php echo e(__('messages.cleansing_detox')); ?></li>
                <li data-filter=".filter-Fiber"><?php echo e(__('messages.fiber')); ?></li>
                <li data-filter=".filter-Bones_Joints"><?php echo e(__('messages.bones_joints')); ?></li>
                <li data-filter=".filter-Hair_Care"><?php echo e(__('messages.hair_care')); ?></li>
                <li data-filter=".filter-Capsules"><?php echo e(__('messages.capsules')); ?></li>
                <li data-filter=".filter-Hair_Skin_and_Nails"><?php echo e(__('messages.hair_skin_nails')); ?></li>
                <li data-filter=".filter-Skeletal_System"><?php echo e(__('messages.skeletal_system')); ?></li>
                <li data-filter=".filter-Hepatic_Portal"><?php echo e(__('messages.hepatic_portal')); ?></li>
                <li data-filter=".filter-Shampoo"><?php echo e(__('messages.shampoo')); ?></li>
                <li data-filter=".filter-Personal_hygiene"><?php echo e(__('messages.personal_hygiene')); ?></li>
                <li data-filter=".filter-Conditioner"><?php echo e(__('messages.conditioner')); ?></li>
                <li data-filter=".filter-Corporal_Care"><?php echo e(__('messages.body_care')); ?></li>
                <li data-filter=".filter-Aches_Pains"><?php echo e(__('messages.pains_aches')); ?></li>
                <li data-filter=".filter-Ointment"><?php echo e(__('messages.ointment')); ?></li>
            </ul>

            <div class="row gy-4 isotope-container" data-aos="fade-up" data-aos-delay="200">
                <?php if($products->isEmpty()): ?>
                    <div class="col-12 text-center">
                        <p><?php echo e(__('messages.no_products_available')); ?></p>
                    </div>
                <?php else: ?>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-3 col-md-4 col-sm-6 portfolio-item isotope-item filter-<?php echo e($product->category); ?>">
                            <div class="card">
                                <a href="<?php echo e(asset('storage/' . $product->image)); ?>" class="glightbox">
                                    <img src="<?php echo e(asset('storage/' . $product->image)); ?>" class="card-img-top" alt="<?php echo e($product->name); ?>">
                                </a>
                                <div class="card-body d-flex flex-column">
                                    <h5 class="card-title"><?php echo e($product->name); ?></h5>
                                    <div class="card-text category-price">
                                        <p class="mb-1">Categoría: <?php echo e(__('messages.' . $product->category)); ?></p>
                                        <p class="mb-1">Precio Regular: <s class="text-muted">$<?php echo e(number_format($product->price, 2)); ?></s></p>
                                        <p class="mb-1">Precio Actual: 
                                            <span class="<?php echo e($product->is_discounted ? 'discounted-price' : ''); ?>">
                                                $<?php echo e(number_format($product->is_discounted && $product->discount_price ? $product->discount_price : $product->price, 2)); ?>

                                            </span>
                                        </p>
                                    </div>
                                    <div class="d-flex justify-content-between mb-3">
                                        <a href="<?php echo e(asset('storage/' . $product->image)); ?>" class="glightbox" title="">
                                            <i class="bi bi-zoom-in fs-4 text-success"></i>
                                        </a>
                                        <a href="<?php echo e(route('store.show', $product->id)); ?>" title="Ver detalles">
                                            <i class="bi bi-link-45deg fs-4 text-success"></i>
                                        </a>
                                    </div>
                                    <div class="input-group mb-3 quantity-box">
                                        <button class="btn btn-outline-secondary" type="button" onclick="this.nextElementSibling.stepDown()">-</button>
                                        <input type="number" class="form-control text-center" value="1" min="1" max="100" data-product-id="<?php echo e($product->id); ?>">
                                        <button class="btn btn-outline-secondary" type="button" onclick="this.previousElementSibling.stepUp()">+</button>
                                    </div>
                                    <button class="btn btn-primary add-to-cart mt-auto" data-product-id="<?php echo e($product->id); ?>"><?php echo e(__('messages.add_to_cart')); ?></button>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section><?php /**PATH C:\xampp\htdocs\herbalsolutions\resources\views/partials/store-content.blade.php ENDPATH**/ ?>