

<?php $__env->startSection('title', 'Productos - Panel de Administración - Herbal Solutions'); ?>
<?php $__env->startSection('body-class', 'admin-page'); ?>

<?php $__env->startSection('content'); ?>
    <section id="admin-products" class="section">
        <div class="container">
            <h2>Gestionar Productos</h2>
            <div class="mb-3">
                <a href="<?php echo e(route('admin.products.create')); ?>" class="btn btn-success">Crear Nuevo Producto</a>
            </div>

            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if($products->isEmpty()): ?>
                <p>No hay productos registrados.</p>
            <?php else: ?>
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Nombre</th>
                            <th>Precio</th>
                            <th>Imagen</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($product->name); ?></td>
                                <td>$<?php echo e(number_format($product->price, 2)); ?></td>
                                <td>
                                    <?php if($product->image): ?>
                                        <img src="<?php echo e(asset($product->image)); ?>" alt="<?php echo e($product->name); ?>" style="max-width: 100px;">
                                    <?php else: ?>
                                        Sin imagen
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.products.edit', $product)); ?>" class="btn btn-sm btn-warning">Editar</a>
                                    <form action="<?php echo e(route('admin.products.destroy', $product)); ?>" method="POST" style="display: inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('¿Estás seguro de eliminar este producto?')">Eliminar</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\herbalsolutions\resources\views/admin/products/index.blade.php ENDPATH**/ ?>