<header id="header" class="header sticky-top">
    <div class="topbar d-flex align-items-center light-background">
        <div class="container d-flex justify-content-center justify-content-md-between">
            <div class="contact-info d-flex align-items-center">
                <i class="bi bi-envelope d-flex align-items-center"><a href="mailto:info@herbalsolutions.com"><?php echo e(__('messages.email')); ?></a></i>
                <i class="bi bi-phone d-flex align-items-center ms-4"><span><?php echo e(__('messages.phone')); ?>: +1 (214) 337-0225</span></i>
            </div>
            <div class="d-flex align-items-center">
                <!-- Botones de redes sociales -->
                <div class="social-links d-none d-md-flex align-items-center me-3">
                    <a href="https://www.tiktok.com/@herbalsolutions.usa" class="tiktok" target="_blank" rel="noopener noreferrer">
                      <i class="bi bi-tiktok"></i>
                    </a>
                    <a href="https://www.facebook.com/herbalsolutionsus" class="facebook" target="_blank" rel="noopener noreferrer">
                      <i class="bi bi-facebook"></i>
                    </a>
                    <a href="https://www.instagram.com/herbalsolutions.usa/" class="instagram" target="_blank" rel="noopener noreferrer">
                      <i class="bi bi-instagram"></i>
                    </a>
                </div>
                <!-- Botón de cambio de idioma -->
                <div class="language-switcher">
                    <?php if(session('locale') == 'es'): ?>
                        <a href="<?php echo e(route('language.switch', ['language' => 'en'])); ?>" class="btn btn-sm btn-outline-light">English</a>
                    <?php else: ?>
                        <a href="<?php echo e(route('language.switch', ['language' => 'es'])); ?>" class="btn btn-sm btn-outline-light">Español</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div><!-- End Top Bar -->

    <div class="branding d-flex align-items-center">
        <div class="container position-relative d-flex align-items-center justify-content-between">
            <a href="<?php echo e(route('home')); ?>" class="logo d-flex align-items-center">
                <img src="<?php echo e(asset('assets/img/logo.png')); ?>" alt="">
                <h1 class="sitename">Herbal Solutions</h1>
            </a>

            <nav id="navmenu" class="navmenu">
                <ul>
                    <li><a href="<?php echo e(route('home')); ?>" class="<?php echo e(request()->routeIs('home') ? 'active' : ''); ?>"><?php echo e(__('messages.home')); ?></a></li>
                    <li><a href="<?php echo e(route('store')); ?>" class="<?php echo e(request()->routeIs('store') ? 'active' : ''); ?>"><?php echo e(__('messages.store')); ?></a></li>
                    <li><a href="<?php echo e(url('/about')); ?>" class="<?php echo e(request()->is('about') ? 'active' : ''); ?>"><?php echo e(__('messages.about')); ?></a></li>
                    <li><a href="<?php echo e(route('services')); ?>" class="<?php echo e(request()->routeIs('services') ? 'active' : ''); ?>"><?php echo e(__('messages.categoria')); ?></a></li>
                    <li><a href="<?php echo e(route('testimonials')); ?>" class="<?php echo e(request()->routeIs('testimonials') ? 'active' : ''); ?>"><?php echo e(__('messages.testimonials')); ?></a></li>
                    <!--<li><a href="<?php echo e(route('pricing')); ?>" class="<?php echo e(request()->routeIs('pricing') ? 'active' : ''); ?>"><?php echo e(__('messages.pricing')); ?></a></li>
                    <li><a href="<?php echo e(route('blog')); ?>" class="<?php echo e(request()->routeIs('blog') ? 'active' : ''); ?>"><?php echo e(__('messages.blog')); ?></a></li>-->
                    <li><a href="<?php echo e(route('contact')); ?>" class="<?php echo e(request()->routeIs('contact') ? 'active' : ''); ?>"><?php echo e(__('messages.contact')); ?></a></li>


                    <!-- Dropdown Start -->
                    <li class="dropdown has-dropdown">
                        <a href="#" class="dropdown-toggle <?php echo e(request()->is('category*') ? 'active' : ''); ?>">
                            <?php echo e(__('messages.productos')); ?>

                        </a>
                        <ul class="dd-menu dd-menu-2col">
                            <li><a href="#" data-filter="*" class="filter-active"><?php echo e(__('messages.all')); ?></a></li>
                            <li><a href="#" data-filter=".filter-cinturita"><?php echo e(__('messages.waistline')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Dietary_Supplement"><?php echo e(__('messages.dietary_supplement')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Digestion_Gut"><?php echo e(__('messages.digestion_stomach')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Digestive_Intestinal"><?php echo e(__('messages.digestive_intestinal')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Teas"><?php echo e(__('messages.teas')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Weight_Management"><?php echo e(__('messages.weight_control')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Cleansing_Detox"><?php echo e(__('messages.cleansing_detox')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Fiber"><?php echo e(__('messages.fiber')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Bones_Joints"><?php echo e(__('messages.bones_joints')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Hair_Care"><?php echo e(__('messages.hair_care')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Capsules"><?php echo e(__('messages.capsules')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Hair_Skin_and_Nails"><?php echo e(__('messages.hair_skin_nails')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Skeletal_System"><?php echo e(__('messages.skeletal_system')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Hepatic_Portal"><?php echo e(__('messages.hepatic_portal')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Shampoo"><?php echo e(__('messages.shampoo')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Personal_hygiene"><?php echo e(__('messages.personal_hygiene')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Conditioner"><?php echo e(__('messages.conditioner')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Corporal_Care"><?php echo e(__('messages.body_care')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Aches_Pains"><?php echo e(__('messages.pains_aches')); ?></a></li>
                            <li><a href="#" data-filter=".filter-Ointment"><?php echo e(__('messages.ointment')); ?></a></li>
                        </ul>
                    </li>
                    <!-- Dropdown End -->

                    <style>
                    #navmenu .dd-menu.dd-menu-2col {
                      display: none;
                      position: absolute;
                      left: 0;
                      top: 100%;
                      background: #fff;
                      padding: 10px 0;
                      box-shadow: 0 0 30px rgba(0, 0, 0, 0.1);
                      border-radius: 4px;
                      min-width: 320px;
                      z-index: 99;
                      grid-template-columns: repeat(2, 1fr);
                      gap: 0;
                    }

                    #navmenu .dd-menu.dd-menu-2col li {
                      width: 100%;
                    }

                    #navmenu .dd-menu.dd-menu-2col li a {
                      display: block;
                      padding: 10px 20px;
                      color: #444444;
                      transition: 0.3s;
                      font-size: 15px;
                      text-decoration: none;
                    }

                    #navmenu .dd-menu.dd-menu-2col li a:hover {
                      color: #009970;
                    }

                    /* Desktop: Mostrar en hover y 2 columnas */
                    @media (min-width: 1200px) {
                      #navmenu .dropdown.has-dropdown:hover .dd-menu.dd-menu-2col {
                        display: grid;
                      }
                    }

                    /* Mobile: Una sola columna */
                    @media (max-width: 1199px) {
                      #navmenu .dd-menu.dd-menu-2col {
                        position: static;
                        background: transparent;
                        box-shadow: none;
                        display: block;
                        min-width: 0;
                        grid-template-columns: none;
                      }
                    }
                    </style>
                </ul>
                <i class="mobile-nav-toggle d-xl-none bi bi-list"></i>
            </nav>

            <!-- Carrito con margen reducido -->
            <div class="cart-icon ms-0 d-flex align-items-center">
                <a href="#" id="cart-link" data-bs-toggle="modal" data-bs-target="#cartModal" class="d-flex align-items-center">
                    <i class="bi bi-cart"></i>
                    <span id="cart-count" class="badge bg-primary rounded-pill ms-1">0</span>
                </a>
            </div>
        </div>
    </div>
</header>

<!-- Estilos específicos para el dropdown -->
<style>
#navmenu .dropdown.has-dropdown {
    position: relative;
}

#navmenu .dropdown.has-dropdown > a {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

#navmenu .dropdown.has-dropdown > a .bi-chevron-down {
    margin-left: 5px;
}

#navmenu .dd-menu {
    display: none;
    position: absolute;
    left: 0;
    top: 100%;
    background: #fff;
    padding: 10px 0;
    box-shadow: 0 0 30px rgba(0, 0, 0, 0.1);
    border-radius: 4px;
    min-width: 200px;
    z-index: 99;
}

#navmenu .dd-menu li {
    padding: 0;
    margin: 0;
    list-style: none;
}

#navmenu .dd-menu li a {
    display: block;
    padding: 10px 20px;
    color: #444444;
    transition: 0.3s;
    font-size: 15px;
    text-decoration: none;
}

#navmenu .dd-menu li a:hover {
    color: #009970;
}

#navmenu .dd-menu .dropdown-divider {
    margin: 5px 0;
    border-top: 1px solid #e9ecef;
}

/* Desktop: Mostrar en hover */
@media (min-width: 1200px) {
    #navmenu .dropdown.has-dropdown:hover .dd-menu {
        display: block;
    }
}

/* Mobile: Mostrar en click */
@media (max-width: 1199px) {
    #navmenu .dd-menu {
        position: static;
        background: transparent;
        padding-left: 15px;
        box-shadow: none;
    }
    
    #navmenu .dropdown.has-dropdown.show .dd-menu {
        display: block;
    }
}
</style>

<!-- JavaScript para el manejo del dropdown y filtrado Isotope -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Dropdown/menu responsive
    const dropdowns = document.querySelectorAll('#navmenu .dropdown.has-dropdown');
    dropdowns.forEach(dropdown => {
        const toggleBtn = dropdown.querySelector('.dropdown-toggle');
        toggleBtn.addEventListener('click', function(e) {
            e.preventDefault();
            if (window.innerWidth < 1200) {
                dropdowns.forEach(other => {
                    if (other !== dropdown) {
                        other.classList.remove('show');
                    }
                });
                dropdown.classList.toggle('show');
            }
        });
    });
    document.addEventListener('click', function(e) {
        if (window.innerWidth < 1200) {
            if (!e.target.closest('#navmenu .dropdown.has-dropdown')) {
                dropdowns.forEach(dropdown => {
                    dropdown.classList.remove('show');
                });
            }
        }
    });
    let timeout;
    window.addEventListener('resize', function() {
        clearTimeout(timeout);
        timeout = setTimeout(() => {
            dropdowns.forEach(dropdown => {
                dropdown.classList.remove('show');
            });
        }, 250);
    });

    // --- Isotope Filtro desde dropdown ---

    // Espera a que Isotope esté disponible y la sección de productos exista
    var isoContainer = document.querySelector('.isotope-container');
    if (isoContainer && typeof Isotope !== 'undefined') {
        var iso = Isotope.data(isoContainer) || new Isotope(isoContainer, {
            itemSelector: '.isotope-item',
            layoutMode: 'masonry'
        });

        // Filtros del dropdown
        var dropdownLinks = document.querySelectorAll('.dd-menu a[data-filter]');
        dropdownLinks.forEach(function(link) {
            link.addEventListener('click', function(e) {
                e.preventDefault();
                var filterValue = this.getAttribute('data-filter');
                iso.arrange({ filter: filterValue });
                // Maneja clase activo en todos los filtros
                document.querySelectorAll('[data-filter]').forEach(function(el) {
                    el.classList.remove('filter-active');
                });
                this.classList.add('filter-active');
                // Cierra el menú en móvil
                var parentDropdown = this.closest('.dd-menu');
                if (parentDropdown && window.innerWidth < 1200) {
                    parentDropdown.parentElement.classList.remove('show');
                }
            });
        });

        // Sincroniza barra de filtros horizontal (si la tienes)
        var barLinks = document.querySelectorAll('.portfolio-filters li[data-filter]');
        barLinks.forEach(function(li) {
            li.addEventListener('click', function() {
                document.querySelectorAll('[data-filter]').forEach(function(el) {
                    el.classList.remove('filter-active');
                });
                this.classList.add('filter-active');
            });
        });
    }
});
</script><?php /**PATH C:\xampp\htdocs\herbalsolutions\resources\views/partials/header.blade.php ENDPATH**/ ?>