<!-- resources/views/about.blade.php -->


<?php $__env->startSection('content'); ?>
    <!-- Page Title -->
    <div class="page-title dark-background">
      <div class="container d-lg-flex justify-content-between align-items-center">
        <h1 class="mb-2 mb-lg-0">About</h1>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="<?php echo e(url('/')); ?>" class="<?php echo e(request()->is('/') ? 'active' : ''); ?>">Home</a></li>
            <li class="current">About</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->

    <!-- About Section -->
    <section id="about" class="about section">

      <div class="container">

        <div class="row gy-4">          
          <div class="col-lg-6" data-aos="fade-up" data-aos-delay="100">
            <div class="content ps-0 ps-lg-5">
              <h3><?php echo e(__('messages.abouth3')); ?></h3>
              <img src="<?php echo e(asset('assets/img/about.jpg')); ?>" class="img-fluid rounded-4 mb-4" alt="">
              <ul>
                <li><i class="bi bi-check-circle-fill"></i> <span><?php echo e(__('messages.lista1')); ?></span></li>
                <p class="fst-italic"><?php echo e(__('messages.listap1')); ?> </p>
                <li><i class="bi bi-check-circle-fill"></i> <span><?php echo e(__('messages.lista2')); ?></span></li>
                <p class="fst-italic"><?php echo e(__('messages.listap2')); ?></p>
                <li><i class="bi bi-check-circle-fill"></i> <span><?php echo e(__('messages.lista3')); ?></span></li>
                <p class="fst-italic"><?php echo e(__('messages.listap3')); ?></p>
              </ul>
            </div>
          </div>
          <div class="col-lg-6" data-aos="fade-up" data-aos-delay="250">
            <div class="content ps-0 ps-lg-5">
              <h4><?php echo e(__('messages.creemos')); ?></h4>
              <ul>
                <li><i class="bi bi-check-circle-fill"></i> <span><?php echo e(__('messages.creemos1')); ?></span></li>
                <li><i class="bi bi-check-circle-fill"></i> <span><?php echo e(__('messages.creemos2')); ?></span></li>
                <li><i class="bi bi-check-circle-fill"></i> <span><?php echo e(__('messages.creemos3')); ?></span></li>
                <li><i class="bi bi-check-circle-fill"></i> <span><?php echo e(__('messages.creemos4')); ?></span></li>
                <li><i class="bi bi-check-circle-fill"></i> <span><?php echo e(__('messages.creemos5')); ?></span></li>
                <li><i class="bi bi-check-circle-fill"></i> <span><?php echo e(__('messages.creemos6')); ?></span></li>
                <li><i class="bi bi-check-circle-fill"></i> <span><?php echo e(__('messages.creemos7')); ?></span></li>
                <li><i class="bi bi-check-circle-fill"></i> <span><?php echo e(__('messages.creemos8')); ?></span></li>
              </ul>
              <h4><?php echo e(__('messages.acuerdo')); ?></h4>
              <ul>
                <li><i class="bi bi-x-circle-fill text-danger"></i> <span><?php echo e(__('messages.acuerdo1')); ?></span></li>
                <li><i class="bi bi-x-circle-fill text-danger"></i> <span><?php echo e(__('messages.acuerdo2')); ?></span></li>
                <li><i class="bi bi-x-circle-fill text-danger"></i> <span><?php echo e(__('messages.acuerdo3')); ?></span></li>
                <li><i class="bi bi-x-circle-fill text-danger"></i> <span><?php echo e(__('messages.acuerdo4')); ?></span></li>
                <li><i class="bi bi-x-circle-fill text-danger"></i> <span><?php echo e(__('messages.acuerdo5')); ?></span></li>
                <li><i class="bi bi-x-circle-fill text-danger"></i> <span><?php echo e(__('messages.acuerdo6')); ?></span></li>
              </ul>
              <!--<div class="position-relative mt-4">
                <img src="<?php echo e(asset('assets/img/about-2.jpg')); ?>" class="img-fluid rounded-4" alt="">
                <a href="https://www.youtube.com/watch?v=Y7f98aduVJ8" class="glightbox pulsating-play-btn"></a>
              </div>
            </div>-->
            <div class="position-relative mt-4">
              <img src="<?php echo e(asset('assets/img/about-2.jpg')); ?>" class="img-fluid" alt="">
              <video class="glightbox pulsating-play-btn" controls>
                <source src="<?php echo e(asset('assets/videos/video_about.mp4')); ?>" type="video/mp4">
                Your browser does not support the video tag.
              </video>
            </div>
          </div>
        </div>

      </div>

    </section><!-- /About Section -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\herbalsolutions\resources\views/about.blade.php ENDPATH**/ ?>