<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\StoreController;
use App\Http\Controllers\Auth\RegisterController as AuthRegisterController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\RegisterController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\PaymentController;

Route::middleware(['web'])->group(function () {
    Route::get('/', [StoreController::class, 'indexWelcome'])->name('home');

    Route::get('/about', function () {
        return view('about');
    });

    Route::get('/services', function () {
        return view('services');
    })->name('services');

    Route::get('/testimonials', function () {
        return view('testimonials');
    })->name('testimonials');

    Route::get('/pricing', function () {
        return view('pricing');
    })->name('pricing');

    Route::get('/portfolio', function () {
        return view('portfolio');
    })->name('portfolio');

    Route::get('/blog', function () {
        return view('blog');
    })->name('blog');

    Route::get('/contact', function () {
        return view('contact');
    })->name('contact');

    Route::post('/contact', [ContactController::class, 'send'])->name('contact.send');

    Route::get('/terms-of-use', function () {
        return view('terms-of-use');
    })->name('terms-of-use');

    Route::get('/privacy-policy', function () {
        return view('privacy-policy');
    })->name('privacy-policy');

    Route::get('/refund_returns', function () {
        return view('refund_returns');
    })->name('refund_returns');

    // Ruta para registro de clientes (original)
    Route::get('/client-register', [RegisterController::class, 'showRegistrationForm'])->name('client.register');
    Route::post('/client-register', [RegisterController::class, 'submit'])->name('client-archive');

    Route::get('/language/switch', [LanguageController::class, 'switch'])->name('language.switch');

    // Rutas de la tienda
    Route::get('/store', [StoreController::class, 'index'])->name('store');
    Route::post('/cart/add', [StoreController::class, 'addToCart'])->name('cart.add');
    Route::post('/cart/remove', [StoreController::class, 'removeFromCart'])->name('cart.remove');
    Route::get('/cart', [StoreController::class, 'getCart'])->name('cart.get');
    Route::get('/checkout', [StoreController::class, 'checkout'])->name('checkout');
    // Nueva ruta para la página de detalles de producto
    Route::get('/store/{id}', [StoreController::class, 'show'])->name('store.show');

    // Ruta para pagos
    Route::post('/payment', [PaymentController::class, 'process'])->name('payment');

    // Rutas de autenticación
    Route::get('/signup', [AuthRegisterController::class, 'showRegistrationForm'])->name('register');
    Route::post('/signup', [AuthRegisterController::class, 'register'])->name('register.submit');
    Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [LoginController::class, 'login']);
    Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

    // Rutas de administración
    Route::prefix('admin')->middleware('auth')->group(function () {
        Route::get('/dashboard', [AdminController::class, 'index'])->name('admin.dashboard');
        Route::get('/products', [ProductController::class, 'index'])->name('admin.products.index');
        Route::get('/products/create', [ProductController::class, 'create'])->name('admin.products.create');
        Route::post('/products', [ProductController::class, 'store'])->name('admin.products.store');
        Route::get('/products/{product}/edit', [ProductController::class, 'edit'])->name('admin.products.edit');
        Route::put('/products/{product}', [ProductController::class, 'update'])->name('admin.products.update');
        Route::delete('/products/{product}', [ProductController::class, 'destroy'])->name('admin.products.destroy');
    });
});