@extends('layouts.app')

@section('title', 'Bienvenido a Herbal Solutions')
@section('body-class', 'index-page')

@section('content')
    <!-- Hero Section -->
    <section id="hero" class="hero section dark-background">
        <div id="hero-carousel" class="carousel slide carousel-fade" data-bs-ride="carousel" data-bs-interval="5000">
            <div class="carousel-item active">
                <img src="{{ asset('assets/img/hero-carousel/hero-1.jpg') }}" alt="Hero 1">
                <!--<div class="container">
                    <h2>{{ __('messages.h2carousel1') }}</h2>
                    <p>{{ __('messages.pcarousel1') }}</p>
                </div>-->
            </div>
            <div class="carousel-item">
                <img src="{{ asset('assets/img/hero-carousel/hero-2.jpg') }}" alt="Hero 2">
                <!--<div class="container">
                    <h2>{{ __('messages.h2carousel2') }}</h2>
                    <p>{{ __('messages.pcarousel2') }}</p>
                </div>-->
            </div>
            <div class="carousel-item">
                <img src="{{ asset('assets/img/hero-carousel/hero-3.jpg') }}" alt="Hero 3">
                <!--<div class="container">
                    <h2>{{ __('messages.h2carousel3') }}</h2>
                    <p>{{ __('messages.pcarousel3') }}</p>
                </div>-->
            </div>
            <div class="carousel-item">
                <img src="{{ asset('assets/img/hero-carousel/hero-4.jpg') }}" alt="Hero 4">
                <!--<div class="container">
                    <h2>{{ __('messages.h2carousel3') }}</h2>
                    <p>{{ __('messages.pcarousel3') }}</p>
                </div>-->
            </div>
            <a class="carousel-control-prev" href="#hero-carousel" role="button" data-bs-slide="prev">
                <span class="carousel-control-prev-icon bi bi-chevron-left" aria-hidden="true"></span>
            </a>
            <a class="carousel-control-next" href="#hero-carousel" role="button" data-bs-slide="next">
                <span class="carousel-control-next-icon bi bi-chevron-right" aria-hidden="true"></span>
            </a>
            <ol class="carousel-indicators"></ol>
        </div>
    </section><!-- /Hero Section -->

    <!-- Call To Action Section 
    <section id="call-to-action" class="call-to-action section light-background">
        <div class="container">
            <div class="row" data-aos="zoom-in" data-aos-delay="100">
                <div class="col-xl-12 text-center text-xl-start">
                    <h3>{{ __('messages.promesah3') }}</h3>
                    <p>{{ __('messages.promesap') }}</p>
                </div>
            </div>
        </div>
    </section><!-- /Call To Action Section -->



    <!-- Call To Action Section as Carousel -->
    <section id="call-to-action" class="call-to-action section light-background">
        <div class="container">
            <div class="row" data-aos="zoom-in" data-bs-interval="500">
                <div class="col-xl-12">
                    <div id="ctaCarousel" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-inner text-center">
                            <div class="carousel-item active">
                                <h3>{{ __('messages.promesah3') }}</h3>
                                <p>{{ __('messages.promesap') }}</p>
                            </div>
                            <div class="carousel-item">
                                <h3>{{ __('messages.h2carousel1') }}</h3>
                                <p>{{ __('messages.pcarousel1') }}</p>
                            </div>
                            <div class="carousel-item">
                                <h3>{{ __('messages.h2carousel2') }}</h3>
                                <p>{{ __('messages.pcarousel2') }}</p>
                            </div>
                            <div class="carousel-item">
                                <h3>{{ __('messages.h2carousel3') }}</h3>
                                <p>{{ __('messages.pcarousel3') }}</p>
                            </div>
                        </div>
                        <button class="carousel-control-prev" type="button" data-bs-target="#ctaCarousel" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Anterior</span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#ctaCarousel" data-bs-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Siguiente</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- Services Section (REEMPLAZADO CON EL DE LA PÁGINA SERVICES) -->
    <section id="services" class="services section">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="100">
                    <div class="service-item position-relative">
                        <div class="icon">
                            <img src="{{ asset('assets/img/iconos/antiestres.png') }}" alt="Actividad" style="width:80px; height:80px;">
                        </div>
                        <a href="#" class="stretched-link"><h3>{{ __('messages.antiestres') }}</h3></a>
                        <p>{{ __('messages.antiestresp') }}</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="200">
                    <div class="service-item position-relative">
                        <div class="icon">
                            <img src="{{ asset('assets/img/iconos/perdida_de_peso.png') }}" alt="Actividad" style="width:80px; height:80px;">
                        </div>
                        <a href="#" class="stretched-link"><h3>{{ __('messages.perdida_de_peso') }}</h3></a>
                        <p>{{ __('messages.perdida_de_pesop') }}</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="300">
                    <div class="service-item position-relative">
                        <div class="icon">
                            <img src="{{ asset('assets/img/iconos/salud_cardiovascular.png') }}" alt="Actividad" style="width:80px; height:80px;">
                        </div>
                        <a href="#" class="stretched-link"><h3>{{ __('messages.salud_cardiovascular') }}</h3></a>
                        <p>{{ __('messages.salud_cardiovascularp') }}</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="400">
                    <div class="service-item position-relative">
                        <div class="icon">
                            <img src="{{ asset('assets/img/iconos/salud_general.png') }}" alt="Actividad" style="width:80px; height:80px;">
                        </div>
                        <a href="#" class="stretched-link"><h3>{{ __('messages.salud_general') }}</h3></a>
                        <p>{{ __('messages.salud_generalp') }}</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="100">
                    <div class="service-item position-relative">
                        <div class="icon">
                            <img src="{{ asset('assets/img/iconos/salud_y_belleza.png') }}" alt="Actividad" style="width:80px; height:80px;">
                        </div>
                        <a href="#" class="stretched-link"><h3>{{ __('messages.salud_y_belleza') }}</h3></a>
                        <p>{{ __('messages.salud_y_bellezap') }}</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="200">
                    <div class="service-item position-relative">
                        <div class="icon">
                            <img src="{{ asset('assets/img/iconos/sistema_circulatorio.png') }}" alt="Actividad" style="width:80px; height:80px;">
                        </div>
                        <a href="#" class="stretched-link"><h3>{{ __('messages.sistema_circulatorio') }}</h3></a>
                        <p>{{ __('messages.sistema_circulatoriop') }}</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="300">
                    <div class="service-item position-relative">
                        <div class="icon">
                            <img src="{{ asset('assets/img/iconos/sistema_digestivo.png') }}" alt="Actividad" style="width:80px; height:80px;">
                        </div>
                        <a href="#" class="stretched-link"><h3>{{ __('messages.sistema_digestivo') }}</h3></a>
                        <p>{{ __('messages.sistema_digestivop') }}</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="400">
                    <div class="service-item position-relative">
                        <div class="icon">
                            <img src="{{ asset('assets/img/iconos/sistema_estructural.png') }}" alt="Actividad" style="width:80px; height:80px;">
                        </div>
                        <a href="#" class="stretched-link"><h3>{{ __('messages.sistema_estructural') }}</h3></a>
                        <p>{{ __('messages.sistema_estructuralp') }}</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="100">
                    <div class="service-item position-relative">
                        <div class="icon">
                            <img src="{{ asset('assets/img/iconos/salud_sexual.png') }}" alt="Actividad" style="width:80px; height:80px;">
                        </div>
                        <a href="#" class="stretched-link"><h3>{{ __('messages.salud_sexual') }}</h3></a>
                        <p>{{ __('messages.salud_sexualp') }}</p>
                    </div>                    
                </div>
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="200">
                    <div class="service-item position-relative">
                        <div class="icon">
                            <img src="{{ asset('assets/img/iconos/salud_femenina.png') }}" alt="Actividad" style="width:80px; height:80px;">
                        </div>
                        <a href="#" class="stretched-link"><h3>{{ __('messages.salud_femenina') }}</h3></a>
                        <p>{{ __('messages.salud_femeninap') }}</p>
                    </div>                    
                </div>
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="300">
                    <div class="service-item position-relative">
                        <div class="icon">
                            <img src="{{ asset('assets/img/iconos/salud_masculina.png') }}" alt="Actividad" style="width:80px; height:80px;">
                        </div>
                        <a href="#" class="stretched-link"><h3>{{ __('messages.salud_masculina') }}</h3></a>
                        <p>{{ __('messages.salud_masculinap') }}</p>
                    </div>                    
                </div>
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="400">
                    <div class="service-item position-relative">
                        <div class="icon">
                            <img src="{{ asset('assets/img/iconos/sistema_nervioso.png') }}" alt="Actividad" style="width:80px; height:80px;">
                        </div>
                        <a href="#" class="stretched-link"><h3>{{ __('messages.sistema_nervioso') }}</h3></a>
                        <p>{{ __('messages.sistema_nerviosop') }}</p>
                    </div>                    
                </div>
            </div>
        </div>
    </section><!-- /Services Section -->

    <!-- Store Section -->
    @if (isset($products))
        @include('partials.store-content', ['products' => $products])
    @else
        <section id="store" class="portfolio section">
            <div class="container">
                <div class="container section-title" data-aos="fade-up">
                    <h2>{{ __('messages.store') }}</h2>
                    <p>{{ __('messages.explore_products') }}</p>
                </div>
                <div class="row gy-4">
                    <div class="col-12 text-center">
                        <p>{{ __('messages.no_products_available') }}</p>
                    </div>
                </div>
            </div>
        </section>
    @endif

    <!-- Clients Section -->
    <section id="clients" class="clients section">
        <div class="container" data-aos="fade-up" data-aos-delay="100">
            <div class="row g-0 clients-wrap">
                <div class="col-xl-6 col-md-4 client-logo">
                    <img src="{{ asset('assets/img/clients/clien-1.png') }}" class="img-fluid" alt="Cliente 1" style="max-width:350px; height:auto;">
                </div>
                <!--<div class="col-xl-4 col-md-4 client-logo">
                    <img src="{{ asset('assets/img/clients/clien-2.png') }}" class="img-fluid" alt="Cliente 2" style="max-width:100px; height:auto;">
                </div>-->
                <div class="col-xl-6 col-md-4 client-logo">
                    <img src="{{ asset('assets/img/clients/clien-3.png') }}" class="img-fluid" alt="Cliente 3" style="max-width:350px; height:auto;">
                </div>
            </div>
        </div>
    </section><!-- /Clients Section -->
@endsection

@section('styles')
    <link href="{{ asset('assets/css/custom.css') }}" rel="stylesheet">
@endsection