<!-- resources/views/terms-of-use.blade.php -->
@extends('layouts.app')

@section('title', 'Terms of Use - Herbal Solutions')
@section('body-class', 'terms-of-use-page')

@section('content')
    <!-- Page Title -->
    <div class="page-title dark-background">
        <div class="container d-lg-flex justify-content-between align-items-center">
            <h1 class="mb-2 mb-lg-0">Terms of Use</h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="{{ url('/') }}" class="{{ request()->is('/') ? 'active' : '' }}">Home</a></li>
                    <li class="current">Terms of Use</li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Terms of Use Section -->
    <section id="terms-of-use" class="terms-of-use section">
        <div class="container" data-aos="fade-up">
            <div class="row">
                <div class="col-lg-12">
                    <h3>1.- Statement</h3>
                    <p>This Terms of Use Agreement (“Agreement”) sets forth the agreement between Herbal Solution’s Health Inc., (collectively, “HSH” or “we”) and each user (“you” or “user”) governing the use by you of this Site. Please read this Agreement carefully before using this Site. By using this Site, you agree with the terms and conditions contained in this Agreement. If you do not agree to the terms and conditions contained in this Agreement, you do not have to use this Site.
                    In addition, when using particular services or features or making purchases on the Site, you shall be subject to any posted guidelines or policies applicable to such services, features, or purchases that may be posted from time to time. All such guidelines or policies are hereby incorporated by reference into this Agreement. These Terms may change at any time and we encourage you to check this page periodically for any changes. If you continue using the Site following the posting of changes to these terms will mean you accept those changes. Also, when you make purchases on the Site, you shall be subject to any posted guidelines or policies applicable to such services, features, or purchases that may be posted from time to time.</p>

                    <h3>2.- Terms of Sale</h3>
                    <p>By placing an order you are offering to purchase a product and you are subject to:
                    All orders are subject to availability and confirmation of the order price.
                    Dispatch times may vary according to availability and subject to any delays resulting from postal delays or force majeure for which we will not be responsible. In order to contract with HSH, you must be over 18 years of age and possess a valid credit or debit card issued by a bank acceptable to us through website. If your order is accepted we will inform you by email and we will confirm the identity of the party which you have contracted with. This will usually be HSH or may in some cases be a third party. Where a contract is made with a third party HSH is not acting as either agent or principal and the contract is made between yourself and that third party and will be subject to the terms of sale which they supply you. When placing an order you undertake that all details you provide to us are true and accurate, that you are an authorized user of the credit or debit card used to place your order, and that there are sufficient funds to cover the cost of the goods. The cost of foreign products and services may fluctuate. All prices advertised are subject to such changes.</p>

                    <h4>(a) Our Contract</h4>
                    <p>If you place an order, you will receive an acknowledgment e-mail confirming receipt of your order: this email will only be an acknowledgment and will not constitute acceptance of your order. A contract between us will not be formed until we send you confirmation by e-mail that the goods which you ordered have been dispatched to you. Only those goods listed in the confirmation e-mail sent at the time of dispatch will be included in the contract formed.</p>

                    <h4>(b) Pricing and Availability</h4>
                    <p>Whilst we try and ensure that all details, descriptions, and prices that appear on this Website are accurate, errors may occur. If we discover an error in the price of any goods which you have ordered we will inform you of this as soon as possible and give you the option of reconfirming your order at the correct price or canceling it. If we are unable to contact you we will treat the order as cancelled. If you cancel and you have already paid for the goods, you will receive a full refund. Delivery costs will be charged in addition; such additional charges are clearly displayed where applicable and included in the “Total Cost”.</p>

                    <h4>(c) Payment</h4>
                    <p>Upon receiving your order we carry out a standard authorization check on your payment card to ensure there are sufficient funds to fulfill the transaction. Your card will be debited upon authorization being received. The monies received upon the debiting of your card shall be treated as a deposit against the value of the goods you wish to purchase. Once the goods have been dispatched and you have been sent a confirmation email the monies paid as a deposit shall be used as consideration for the value of goods you have purchased as listed in the
                    confirmation email.</p>

                    <h4>(d) Cancellation</h4>
                    <p><strong>Minimum 24 hours notice of cancellation required. Notification for instance, in person, via email, phone, or any other means will be accepted subject to confirmation in writing. We reserve the right to levy a 20% charge over the total order to cover any subsequent administrative expenses.</strong></p>

                    <h3>3.- Log Files</h3>
                    <p>We use IP addresses to analyze trends, administer the site, track user’s movement, and gather broad demographic information for aggregate use. IP addresses are not linked to personally identifiable information. Additionally, for systems administration, detecting usage patterns, and troubleshooting purposes, our web servers automatically log standard access information including browser type, access times/open mail, URL requested, and referral URL. This information is not shared with third parties and is used only within this Company on a need-to-know basis. Any individually identifiable information related to this data will never be used in any way different from that stated above without your explicit permission.</p>

                    <h3>4.- Cookies</h3>
                    <p>Like most interactive websites this Company’s website [or ISP] uses cookies to enable us to retrieve user details for each visit. Cookies are used in some areas of our site to enable the functionality of this area and ease of use for those people visiting. Some of our affiliate partners may also use cookies.</p>

                    <h3>5.-Copyright Notice</h3>
                    <p>This Company’s logo is a registered trademark of this Company in the United States Of America and other countries. The brand names and specific services of this Company featured on this website are trademarked. Copyright and other relevant intellectual property rights exist on all text relating to the Company’s services and the full content of this website.</p>

                    <h3>6.- Entire Agreement</h3>
                    <p>The above Terms of Use constitute the entire agreement of the parties and supersede any and all preceding and contemporaneous agreements between you and HSH. Any waiver of any provision of the Terms of Service will be effective only if in writing and signed by a Director of HSH</p>
                </div>
            </div>
        </div>
    </section><!-- End Terms of Use Section -->
@endsection