@extends('layouts.app')

@section('title', 'Tienda - Herbal Solutions')
@section('body-class', 'portfolio-page')

@section('content')
    <!-- Page Title -->
    <div class="page-title dark-background">
        <div class="container d-lg-flex justify-content-between align-items-center">
            <h1 class="mb-2 mb-lg-0">{{ __('messages.store') }}</h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="{{ url('/') }}" class="{{ request()->is('/') ? 'active' : '' }}">{{ __('messages.home') }}</a></li>
                    <li class="current">{{ __('messages.store') }}</li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Store Section -->
    @include('partials.store-content', ['products' => $products])
@endsection

@section('styles')
    <link href="{{ asset('assets/css/custom.css') }}" rel="stylesheet">
@endsection