<!-- resources/views/register.blade.php -->
@extends('layouts.app')

@section('title', __('messages.client_register') . ' - Herbal Solutions')
@section('body-class', 'register-page')

@section('content')
    <!-- Page Title -->
    <div class="page-title dark-background">
        <div class="container d-lg-flex justify-content-between align-items-center">
            <h1 class="mb-2 mb-lg-0">{{ __('messages.client_register') }}</h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="{{ url('/') }}" class="{{ request()->is('/') ? 'active' : '' }}">{{ __('messages.home') }}</a></li>
                    <li class="current">{{ __('messages.client_register') }}</li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Register Section -->
    <section id="register" class="register section">
        <div class="container" data-aos="fade-up">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <h2>{{ __('messages.client_register') }}</h2>
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form action="{{ route('client.register.submit') }}" method="POST" class="register-form">
                        @csrf
                        <div class="row">
                            <div class="col-md-6 form-group mb-3">
                                <label for="first_name">{{ __('messages.first_name') }}</label>
                                <input type="text" name="first_name" class="form-control" id="first_name" value="{{ old('first_name') }}" required>
                            </div>
                            <div class="col-md-6 form-group mb-3">
                                <label for="last_name">{{ __('messages.last_name') }}</label>
                                <input type="text" name="last_name" class="form-control" id="last_name" value="{{ old('last_name') }}" required>
                            </div>
                        </div>
                        <div class="form-group mb-3">
                            <label for="email">{{ __('messages.email_field') }}</label>
                            <input type="email" name="email" class="form-control" id="email" value="{{ old('email') }}" required>
                        </div>
                        <div class="form-group mb-3">
                            <label for="phone">{{ __('messages.phone_number') }}</label>
                            <input type="tel" name="phone" class="form-control" id="phone" value="{{ old('phone') }}" required>
                        </div>
                        <div class="form-group mb-3">
                            <label for="account_type">{{ __('messages.account_type') }}</label>
                            <select name="account_type" class="form-control" id="account_type" required>
                                <option value="" disabled selected>{{ __('messages.select_account_type') }}</option>
                                <option value="individual_customer" {{ old('account_type') == 'individual_customer' ? 'selected' : '' }}>{{ __('messages.individual_customer') }}</option>
                                <option value="wholesale_account" {{ old('account_type') == 'wholesale_account' ? 'selected' : '' }}>{{ __('messages.wholesale_account') }}</option>
                            </select>
                        </div>
                        <div class="text-center">
                            <button type="submit" class="btn btn-primary">{{ __('messages.submit_register') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section><!-- End Register Section -->
@endsection