<!-- resources/views/refund_returns.blade.php -->
@extends('layouts.app')

@section('title', 'Refund & Returns - Herbal Solutions')
@section('body-class', 'refund-returns-page')

@section('content')
    <!-- Page Title -->
    <div class="page-title dark-background">
        <div class="container d-lg-flex justify-content-between align-items-center">
            <h1 class="mb-2 mb-lg-0">Refund & Returns</h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="{{ url('/') }}" class="{{ request()->is('/') ? 'active' : '' }}">Home</a></li>
                    <li class="current">Refund & Returns</li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Refund & Returns Section -->
    <section id="refund-returns" class="refund-returns section">
        <div class="container" data-aos="fade-up">
            <div class="row">
                <div class="col-lg-12">
                    <h2>Refund & Returns Policy</h2>
                    <p>Our refund and returns policy lasts 30 days. If 30 days have passed since your purchase, we can’t offer you a full refund or exchange. To be eligible for a return, your item must be unused and in the same condition that you received it. It must also be in the original packaging. Several types of goods are exempt from being returned. Perishable goods such as food, cannot be returned. We also do not accept products that are intimate or sanitary goods. Additional non-returnable items:</br>
                        <ul>
                            <li>Gift cards</li>
                            <li>Some health and personal care items</li>
                        </ul>
                    To complete your return, we require a receipt or proof of purchase.</br>
                    Please do not send your purchase back to the manufacturer.</br>
                    There are certain situations where only partial refunds are granted</br>
                        <ul>
                            <li>Any item not in its original condition is damaged or missing parts for reasons not due to our error.</li>
                            <li>Any item that is returned more than 30 days after delivery</li>
                        </ul>
                    <h2>Refund</h2>
                    Once your return is received and inspected, we will send you an email to notify you that we have received your returned item. We will also notify you of the approval or rejection of your refund.<br>
                    If you are approved, then your refund will be processed, and a credit will automatically be applied to your credit card or original method of payment, within a certain amount of days.<br>
                    <strong>Late or missing refunds</strong>
                    If you haven’t received a refund yet, first check your bank account again.<br>
                    Then contact your credit card company, it may take some time before your refund is officially posted.<br>
                    Next, contact your bank. There is often some processing time before a refund is posted.
                    If you’ve done all of this and you still have not received your refund yet, please contact us at info@herbalsolutions.com.<br>
                    <strong>Sale items</strong>
                    Only regular-priced items may be refunded. Sale items cannot be refunded.<br>
                    <h2>Exchanges</h2>
                    We only replace items if they are defective or damaged. If you need to exchange it for the same item, send us an email at info@herbalsolutions.com and send your item to: 3224 S Westmoreland Rd, Dallas, TX 75233 USA.<br>
                    To return your product, you should mail your product to: 3224 S Westmoreland Rd, Dallas, TX 75233 USA.<br>
                    You will be responsible for paying for your own shipping costs for returning your item. Shipping costs are non-refundable. If you receive a refund, the cost of return shipping will be deducted from your refund.<br>
                    Depending on where you live, the time it may take for your exchanged product to reach you may vary.<br>
                    If you are returning more expensive items, you may consider using a trackable shipping service or purchasing shipping insurance. We don’t guarantee that we will receive your returned item.</p>
                                    
                    <h3>Contact Us</h3>
                    <p>For questions about this policy, please reach out to us at <a href="mailto:info@herbalsolutions.com">info@herbalsolutions.com</a> or call +1 (214) 337-0225.</p>
                </div>
            </div>
        </div>
    </section><!-- End Refund & Returns Section -->
@endsection