<!-- resources/views/privacy-policy.blade.php -->
@extends('layouts.app')

@section('title', 'Privacy Policy - Herbal Solutions')
@section('body-class', 'privacy-policy-page')

@section('content')
    <!-- Page Title -->
    <div class="page-title dark-background">
        <div class="container d-lg-flex justify-content-between align-items-center">
            <h1 class="mb-2 mb-lg-0">Privacy Policy</h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="{{ url('/') }}" class="{{ request()->is('/') ? 'active' : '' }}">Home</a></li>
                    <li class="current">Privacy Policy</li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Privacy Policy Section -->
    <section id="privacy-policy" class="privacy-policy section">
        <div class="container" data-aos="fade-up">
            <div class="row">
                <div class="col-lg-12">
                    <h2>Privacy Statement</h2>
                    <p>We are committed to protecting your privacy, and your personal information. Generally, HSH website does not reveal any of your Personal Information. When you place an order or, for example, if you subscribe to a mailing list, participate in special offers, sweepstakes, or other promotions, send questions or comments to us via e-mail, post user content on the HSH website, our Facebook page, or other social media site. We will collect personal information that will be used to fulfill your order and for other purposes consistent with this Privacy Policy.</p>

                    <h3>Cookies</h3>
                    <p>A cookie is a small amount of data, which may include a unique identifier. Cookies are sent to your browser from a website and stored on your device. Every device that accesses our website is assigned a different cookie by us. We use cookies to recognize your device and provide you with a personalized experience to navigate our website. Also, we use cookies to track your prior visits to our website.</p>

                    <h3>Sharing Your Personal Information</h3>
                    <p>We do never and will never share, disclose, sell, rent, or otherwise provide Personal Information to other companies for the marketing of their own products or services.
                    We do not use the Personal Information we collect from you for telemarketers by phone or another kind like email.</p>

                    <h3>Contact Us</h3>
                    <p>For questions about this Privacy Policy, contact us at <a href="mailto:info@herbalsolutions.com">info@herbalsolutions.com</a>.</p>
                </div>
            </div>
        </div>
    </section><!-- End Privacy Policy Section -->
@endsection