<section id="store" class="portfolio section">
    <div class="container">
        <div class="isotope-layout" data-default-filter="*" data-layout="masonry" data-sort="original-order">
            <div class="container section-title" data-aos="fade-up">
                <h2>{{ __('messages.store') }}</h2>
                <p>{{ __('messages.explore_products') }}</p>
            </div>

            <ul class="portfolio-filters isotope-filters" data-aos="fade-up" data-aos-delay="100">
                <li data-filter="*" class="filter-active">{{ __('messages.all') }}</li>
                <li data-filter=".filter-cinturita">{{ __('messages.waistline') }}</li>
                <li data-filter=".filter-Dietary_Supplement">{{ __('messages.dietary_supplement') }}</li>
                <li data-filter=".filter-Digestion_Gut">{{ __('messages.digestion_stomach') }}</li>
                <li data-filter=".filter-Digestive_Intestinal">{{ __('messages.digestive_intestinal') }}</li>
                <li data-filter=".filter-Teas">{{ __('messages.teas') }}</li>
                <li data-filter=".filter-Weight_Management">{{ __('messages.weight_control') }}</li>
                <li data-filter=".filter-Cleansing_Detox">{{ __('messages.cleansing_detox') }}</li>
                <li data-filter=".filter-Fiber">{{ __('messages.fiber') }}</li>
                <li data-filter=".filter-Bones_Joints">{{ __('messages.bones_joints') }}</li>
                <li data-filter=".filter-Hair_Care">{{ __('messages.hair_care') }}</li>
                <li data-filter=".filter-Capsules">{{ __('messages.capsules') }}</li>
                <li data-filter=".filter-Hair_Skin_and_Nails">{{ __('messages.hair_skin_nails') }}</li>
                <li data-filter=".filter-Skeletal_System">{{ __('messages.skeletal_system') }}</li>
                <li data-filter=".filter-Hepatic_Portal">{{ __('messages.hepatic_portal') }}</li>
                <li data-filter=".filter-Shampoo">{{ __('messages.shampoo') }}</li>
                <li data-filter=".filter-Personal_hygiene">{{ __('messages.personal_hygiene') }}</li>
                <li data-filter=".filter-Conditioner">{{ __('messages.conditioner') }}</li>
                <li data-filter=".filter-Corporal_Care">{{ __('messages.body_care') }}</li>
                <li data-filter=".filter-Aches_Pains">{{ __('messages.pains_aches') }}</li>
                <li data-filter=".filter-Ointment">{{ __('messages.ointment') }}</li>
            </ul>

            <div class="row gy-4 isotope-container" data-aos="fade-up" data-aos-delay="200">
                @if ($products->isEmpty())
                    <div class="col-12 text-center">
                        <p>{{ __('messages.no_products_available') }}</p>
                    </div>
                @else
                    @foreach ($products as $product)
                        <div class="col-lg-3 col-md-4 col-sm-6 portfolio-item isotope-item filter-{{ $product->category }}">
                            <div class="card">
                                <a href="{{ asset('storage/' . $product->image) }}" class="glightbox">
                                    <img src="{{ asset('storage/' . $product->image) }}" class="card-img-top" alt="{{ $product->name }}">
                                </a>
                                <div class="card-body d-flex flex-column">
                                    <h5 class="card-title">{{ $product->name }}</h5>
                                    <div class="card-text category-price">
                                        <p class="mb-1">Categoría: {{ __('messages.' . $product->category) }}</p>
                                        <p class="mb-1">Precio Regular: <s class="text-muted">${{ number_format($product->price, 2) }}</s></p>
                                        <p class="mb-1">Precio Actual: 
                                            <span class="{{ $product->is_discounted ? 'discounted-price' : '' }}">
                                                ${{ number_format($product->is_discounted && $product->discount_price ? $product->discount_price : $product->price, 2) }}
                                            </span>
                                        </p>
                                    </div>
                                    <div class="d-flex justify-content-between mb-3">
                                        <a href="{{ asset('storage/' . $product->image) }}" class="glightbox" title="">
                                            <i class="bi bi-zoom-in fs-4 text-success"></i>
                                        </a>
                                        <a href="{{ route('store.show', $product->id) }}" title="Ver detalles">
                                            <i class="bi bi-link-45deg fs-4 text-success"></i>
                                        </a>
                                    </div>
                                    <div class="input-group mb-3 quantity-box">
                                        <button class="btn btn-outline-secondary" type="button" onclick="this.nextElementSibling.stepDown()">-</button>
                                        <input type="number" class="form-control text-center" value="1" min="1" max="100" data-product-id="{{ $product->id }}">
                                        <button class="btn btn-outline-secondary" type="button" onclick="this.previousElementSibling.stepUp()">+</button>
                                    </div>
                                    <button class="btn btn-primary add-to-cart mt-auto" data-product-id="{{ $product->id }}">{{ __('messages.add_to_cart') }}</button>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </div>
</section>