<!-- resources/views/partials/footer.blade.php -->
<footer id="footer" class="footer dark-background">
    <div class="footer-top">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-4 col-md-6 footer-about">
                    <a href="{{ url('/') }}" class="logo d-flex align-items-center">
                        <span class="sitename">Herbal Solutions</span>
                    </a>
                    <div class="text-left">
                        <img src="{{ asset('assets/img/logo.png') }}" alt="Herbal Solutions Logo" class="img-fluid" style="max-width: 90px;">
                    </div>
                    <div class="footer-contact pt-3">
                        <p><strong>{{ __('messages.address') }}:</strong></p>
                        <p>3224 S Westmoreland Rd, Dallas, TX 75233, United States</p>
                        <p class="mt-3"><strong>{{ __('messages.phone') }}:</strong> <span>+1 (214) 337-0225</span></p>
                        <p><strong>{{ __('messages.email') }}:</strong> <span>info@herbalsolutions.com</span></p>
                    </div>
                </div>

                <div class="col-lg-2 col-md-3 footer-links">
                    <h4>{{ __('messages.useful_links') }}</h4>
                    <ul>
                        <li><a href="{{ url('/') }}">{{ __('messages.home') }}</a></li>
                        <!--<li><a href="{{ url('/portfolio') }}">{{ __('messages.portfolio') }}</a></li>-->
                        <li><a href="{{ url('/store') }}">{{ __('messages.store') }}</a></li>
                        <li><a href="{{ url('/about') }}">{{ __('messages.about') }}</a></li>
                        <li><a href="{{ url('/services') }}">{{ __('messages.services') }}</a></li>
                        <li><a href="{{ url('/testimonials') }}">{{ __('messages.testimonials') }}</a></li>
                        <!--<li><a href="{{ url('/pricing') }}">{{ __('messages.pricing') }}</a></li>-->
                        <!--<li><a href="{{ url('/blog') }}">{{ __('messages.blog') }}</a></li>-->
                        <li><a href="{{ url('/contact') }}">{{ __('messages.contact') }}</a></li>
                    </ul>
                </div>

                <div class="col-lg-2 col-md-3 footer-links">
                    <h4>{{ __('messages.general_information') }}</h4>
                    <ul>
                        <li><a href="{{ url('/terms-of-use') }}">{{ __('messages.terms_of_use') }}</a></li>
                        <li><a href="{{ url('/privacy-policy') }}">{{ __('messages.privacy_policy') }}</a></li>
                        <li><a href="{{ url('/refund_returns') }}">{{ __('messages.refund_returns') }}</a></li>
                        <li><a href="{{ route('client.register') }}">{{ __('messages.client_register') }}</a></li>
                        @auth
                            <li>
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <button type="submit" class="nav-link" style="background: none; border: none; padding: 0; color: inherit;">{{ __('messages.logout') }}</button>
                                </form>
                            </li>
                        @else
                            <li><a href="{{ route('login') }}">{{ __('messages.login') }}</a></li>
                            <li><a href="{{ route('register') }}">{{ __('messages.register') }}</a></li>
                        @endauth
                    </ul>
                </div>

                <div class="col-lg-2 col-md-3 footer-links">
                    <h4>{{ __('messages.payments_accepted') }}</h4>
                    <div class="payment-icons">
                        <div class="row gy-2">
                            <div class="col-6 text-center">
                                <i class="bi bi-apple" style="font-size: 1.5rem;" title="Apple Pay"></i>
                                <span class="d-block mt-1 small">Apple Pay</span>
                            </div>
                            <div class="col-6 text-center">
                                <i class="bi bi-google" style="font-size: 1.5rem;" title="Google Pay"></i>
                                <span class="d-block mt-1 small">Google Pay</span>
                            </div>
                            <div class="col-6 text-center">
                                <i class="bi bi-credit-card" style="font-size: 1.5rem;" title="Visa"></i>
                                <span class="d-block mt-1 small">Visa</span>
                            </div>
                            <div class="col-6 text-center">
                                <i class="bi bi-credit-card-2-front" style="font-size: 1.5rem;" title="Mastercard"></i>
                                <span class="d-block mt-1 small">Mastercard</span>
                            </div>
                            <div class="col-6 text-center">
                                <i class="bi bi-paypal" style="font-size: 1.5rem;" title="PayPal"></i>
                                <span class="d-block mt-1 small">PayPal</span>
                            </div>
                            <div class="col-6 text-center">
                                <i class="bi bi-credit-card-2-back" style="font-size: 1.5rem;" title="Discover"></i>
                                <span class="d-block mt-1 small">Discover</span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-2 col-md-3 footer-links">
                    <h4>{{ __('messages.associated_brands') }}</h4>
                    <ul class="text-center">
                        <li class="d-flex justify-content-center"><img src="{{ asset('assets/img/vitalael.png') }}" alt="Vitalael" style="max-height: 65px;"></li>
                        <li class="d-flex justify-content-center"><img src="{{ asset('assets/img/logo.png') }}" alt="Soyfit" style="max-height: 95px;"></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="copyright text-center">
        <div class="container d-flex flex-column flex-lg-row justify-content-center justify-content-lg-between align-items-center">
            <div class="d-flex flex-column align-items-center align-items-lg-start">
                <div>
                    <footer>
                        <p>{!! __('messages.footer_disclaimer') !!}</p>
                    </footer>
                </div>
                <div>
                    <span style="color: green;">Herbal Solutions Health Inc.</span> {{ __('messages.footer_copyright') }}
                </div>
            </div>

            <div class="social-links order-first order-lg-last mb-3 mb-lg-0">
                <a href="https://www.facebook.com/herbalsolutionsus" class="facebook" target="_blank" rel="noopener noreferrer">
                    <i class="bi bi-facebook"></i>
                </a>
                <a href="https://www.instagram.com/herbalsolutions.usa/" class="instagram" target="_blank" rel="noopener noreferrer">
                    <i class="bi bi-instagram"></i>
                </a>
                <a href="https://www.tiktok.com/@herbalsolutions.usa" class="tiktok" target="_blank" rel="noopener noreferrer">
                    <i class="bi bi-tiktok"></i>
                </a>
            </div>
        </div>
    </div>
</footer>