<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Nuevo pago recibido</title>
</head>
<body>
    <h2>¡Nuevo pago recibido!</h2>
    <p><strong>Nombre de quien recibe:</strong> {{ $data['recipient_name'] }}</p>
    <p><strong>Dirección de envío:</strong> {{ $data['shipping_address'] }}</p>
    <p><strong>Monto pagado:</strong> ${{ number_format($data['amount'], 2) }}</p>
    <p><strong>ID de Transacción:</strong> {{ $data['transaction_id'] }}</p>
    <p><strong>ID de Referencia:</strong> {{ $data['ref_id'] }}</p>
    
    <h3>Resumen del carrito:</h3>
    <table border="1" cellpadding="6" cellspacing="0">
        <thead>
            <tr>
                <th>Producto</th>
                <th>Cantidad</th>
                <th>Precio unitario</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach($data['cart'] as $item)
            <tr>
                <td>{{ $item['name'] ?? '' }}</td>
                <td>{{ $item['quantity'] ?? '' }}</td>
                <td>${{ number_format($item['price'] ?? 0, 2) }}</td>
                <td>${{ number_format(($item['price'] ?? 0) * ($item['quantity'] ?? 0), 2) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>