@extends('layouts.app')

@section('title', 'Registrarse - Herbal Solutions')
@section('body-class', 'register-page')

@section('content')
    <section id="register" class="section light-background">
        <div class="container">
            <div class="section-title" data-aos="fade-up">
                <h2>Registrarse</h2>
                <p>Crea tu cuenta en Herbal Solutions.</p>
            </div>

            <div class="row justify-content-center" data-aos="fade-up" data-aos-delay="100">
                <div class="col-lg-6">
                    <div class="php-email-form" style="background: #fff; padding: 30px; border-radius: 8px; box-shadow: 0px 0px 30px rgba(0, 0, 0, 0.1);">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                {{ $errors->first() }}
                            </div>
                        @endif

                        <form method="POST" action="{{ route('register.submit') }}">
                            @csrf
                            <div class="form-group mb-4">
                                <label for="name" class="form-label">Nombre</label>
                                <input type="text" name="name" id="name" class="form-control" value="{{ old('name') }}" required>
                            </div>

                            <div class="form-group mb-4">
                                <label for="email" class="form-label">Correo Electrónico</label>
                                <input type="email" name="email" id="email" class="form-control" value="{{ old('email') }}" required>
                            </div>

                            <div class="form-group mb-4">
                                <label for="password" class="form-label">Contraseña</label>
                                <input type="password" name="password" id="password" class="form-control" required>
                            </div>

                            <div class="form-group mb-4">
                                <label for="password_confirmation" class="form-label">Confirmar Contraseña</label>
                                <input type="password" name="password_confirmation" id="password_confirmation" class="form-control" required>
                            </div>

                            <div class="text-center">
                                <button type="submit" class="btn btn-primary" style="background: var(--accent-color); border: none; padding: 10px 30px;">Registrarse</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection